<?php

namespace Agent3w\Af2a\Inc\Plugins;

use Agent3w\Af2a\Inc\Agent3w_Af2a;

if( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Wapf_Addon
{
    public function __construct()
    {
        //
    }

    public function init()
    {
        add_action( 'wp_enqueue_scripts', function() {
            if ( function_exists('is_product') && is_product() ) {
                $load_css = defined( 'AF2A_OPTION_WAPF_WCPRODUCT_CSS' ) && AF2A_OPTION_WAPF_WCPRODUCT_CSS === false ? false : true;
                if ( $load_css ) {
                    wp_enqueue_style( 'agent3w-wapf-product', Agent3w_Af2a::$_plugin_dir_url . '/assets/css/wc-product.css', [], false );
                }
                wp_enqueue_script( 'agent3w-wapf-product', Agent3w_Af2a::$_plugin_dir_url . '/assets/js/wc-product.min.js', ['jquery'], false, true );
                wp_localize_script( 'agent3w-wapf-product', 'phpData3w', [
                    'textBase' => defined('AF2A_OPTION_TEXT_BOUTON_INSCRIPTION') && ! empty( AF2A_OPTION_TEXT_BOUTON_INSCRIPTION ) ? AF2A_OPTION_TEXT_BOUTON_INSCRIPTION : __( 'Préinscrire le ou les participants', 'agent3w-af2a' ),
                    'textModif' => defined('AF2A_OPTION_TEXT_BOUTON_MODIF_INSCRIPTION') && ! empty( AF2A_OPTION_TEXT_BOUTON_MODIF_INSCRIPTION ) ? AF2A_OPTION_TEXT_BOUTON_MODIF_INSCRIPTION : __( 'Modifier la liste des participants', 'agent3w-af2a' )
                ] );
            }

            if ( function_exists('is_cart') && is_cart() ) {
                $load_css = defined( 'AF2A_OPTION_WAPF_WCCART_CSS' ) && AF2A_OPTION_WAPF_WCCART_CSS === false ? false : true;
                if ( $load_css ) {
                    wp_enqueue_style( 'agent3w-wapf-cart', Agent3w_Af2a::$_plugin_dir_url . '/assets/css/wc-cart.css', [], false );
                }
            }
            
        }, 200 );

        // Hooks
        // -----
        // Ajoute le bouton inscrire les participant avant le bouton ajouter au panier
        add_action( 'woocommerce_after_add_to_cart_quantity', function() {
            $product = wc_get_product();
            ?>
            <a href="#" class="btn button button-open-customizer"><?= defined('AF2A_OPTION_TEXT_BOUTON_INSCRIPTION') && ! empty( AF2A_OPTION_TEXT_BOUTON_INSCRIPTION ) ? AF2A_OPTION_TEXT_BOUTON_INSCRIPTION : __( 'Préinscrire le ou les participants', 'agent3w-af2a' ) ?></a>
            <?php
        }, 1 );

        // Shortcodes
        // ----------
        add_shortcode( 'agent3w_wc_product_qty_input', [ $this, 'shortcode_wc_product_qty_input' ] );
        add_shortcode( 'agent3w_wc_product_add_to_cart_btn', [ $this, 'shortcode_wc_product_add_to_cart_btn' ] );
    }
    
    /**
     * shortcode_wc_product_qty_input
     * Permet d'afficher le champs de quantité du produit
     *
     * @param  array $atts attributs du shortcode
     */
    public function shortcode_wc_product_qty_input( $atts )
    {
        $atts = shortcode_atts( [
            'show_btns' => false, // afficher les boutons + et -
            'show_plus' => false, // afficher le bouton +
            'show_minus' => false, // afficher le bouton -
            'hide_input' => false, // cacher l'input
        ], $atts );

        $product = wc_get_product();
        if ( empty( $product ) ) {
            return;
        }
        ob_start();
        if ( $atts['hide_input'] === false ) {
            woocommerce_quantity_input(
                array(
                    'min_value'   => apply_filters( 'woocommerce_quantity_input_min', $product->get_min_purchase_quantity(), $product ),
                    'max_value'   => apply_filters( 'woocommerce_quantity_input_max', $product->get_max_purchase_quantity(), $product ),
                    'input_value' => isset( $_POST['quantity'] ) ? wc_stock_amount( wp_unslash( $_POST['quantity'] ) ) : $product->get_min_purchase_quantity(), // WPCS: CSRF ok, input var ok.
                )
            );
        }
        ?>
        <span class="qty--adjust-btns">
        <?php
        if ( $atts['show_btns'] || $atts['show_minus'] ) {
            printf( '<button type="button" role="button" title="%s" class="qty--adjust-btn minus">-</button>', __( 'Supprimer le dernier participant', 'agent3w-af2a' ) );
        }
        if ( $atts['show_btns'] || $atts['show_plus'] ) {
            printf( '<button type="button" role="button" title="%s" class="qty--adjust-btn plus">+</button>', __( 'Ajouter un participant', 'agent3w-af2a' ) );
        }
        ?>
        </span>
        <?php
        return ob_get_clean();
    }
    
    /**
     * shortcode_wc_product_add_to_cart_btn
     * Permet d'afficher le bouton d'ajout au panier sur la page produit
     */
    public function shortcode_wc_product_add_to_cart_btn()
    {
        $product = wc_get_product();
        if ( empty( $product ) ) {
            return;
        }
        ob_start();
        ?>
        <button type="submit" name="add-to-cart" value="<?php echo esc_attr( $product->get_id() ); ?>" class="single_add_to_cart_button button alt show always-show"><?php echo esc_html( $product->single_add_to_cart_text() ); ?></button>
        <?php
        return ob_get_clean();
    }
}
