<?php

    if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
    
    class WooMD_Domain_Edit
        {
            var $functions;
           
            var $tab;
            
            function __construct()
                {
                    global $woo_multidomain;
                    
                    $this->functions    =   $woo_multidomain->functions;
                    
                    $this->tab          =   isset($_GET['tab']) ? $_GET['tab']    :   'domain-info';
                                    
                }
                
            
            function init()
                {
                    
                    $this->run();
                    $this->output();
  
                    
                }
                
            
            function run()
                {    
    
                    global $woo_multidomain;

                    $id = isset( $_REQUEST['id'] ) ? intval( $_REQUEST['id'] ) : 0;

                    if ( ! $id ) {
                        wp_die( __( 'Invalid site ID.' ) );
                    }

                    $details = $this->functions->network->get_domain( $id );
                    if ( ! $details ) {
                        wp_die( __( 'The requested site does not exist.' ) );
                    }

                    $parsed_scheme = parse_url( $details->siteurl, PHP_URL_SCHEME );
                    $is_main_site  = is_main_site( $id );
                }
                
                
            function output()
                {
                    
                    switch ( $this->tab )
                        {
                            case 'domain-info'    :
                                                    include_once( WOOMULTID_PATH . '/includes/admin/domain-info.php' );
                                                    $instance   =   new WooMD_Domain_Edit_Info();
                                                    $instance->init();
                                                    break;    
                            case 'domain-themes'    :
                                                    include_once( WOOMULTID_PATH . '/includes/admin/domain-themes.php' );
                                                    $instance   =   new WooMD_Domain_Edit_Themes();
                                                    $instance->init();
                                                    break; 
                            case 'domain-settings'    :
                                                    include_once( WOOMULTID_PATH . '/includes/admin/domain-settings.php' );
                                                    $instance   =   new WooMD_Domain_Edit_Settings();
                                                    $instance->init();
                                                    break;
                        }
                    
                    
                }
                
        }
        
        
        
?>