<?php

    if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

    class WooMD_Compatibility 
        {
            var $functions;
            
            function __construct()   
                {
                    global $woo_multidomain;
                    
                    $this->functions        =   $woo_multidomain->functions;
                           
                    add_action( 'plugins_loaded',                       array( $this, 'add_3rd_compatibility') );
                    
                }
           
    
            function add_3rd_compatibility()
                {
                    
                    if ( $this->functions->is_plugin_active( 'wordpress-seo/wp-seo.php') === TRUE )
                        include_once ( WOOMULTID_PATH . '/compatibility/wordpress-seo/wp-seo.php');
                        
                    if ( $this->functions->is_plugin_active( 'woocommerce-multilingual/wpml-woocommerce.php') === TRUE )
                        include_once ( WOOMULTID_PATH . '/compatibility/woocommerce-multilingual/woocommerce-multilingual.php');
                        
                    if ( $this->functions->is_plugin_active( 'woocommerce-germanized/woocommerce-germanized.php') === TRUE )
                        include_once ( WOOMULTID_PATH . '/compatibility/woocommerce-germanized/woocommerce-germanized.php');
                    
                    if ( $this->functions->is_plugin_active( 'wpml-string-translation/plugin.php') === TRUE )
                        include_once ( WOOMULTID_PATH . '/compatibility/wpml-string-translation/wpml-string-translation.php');
                                
                }
            
        }


    new WooMD_Compatibility();
        
?>