<?php

    class Woo_General_Content 
        {
            var $functions;
            var $woomd_network;
            
            public static $seek_post_types    =   array  (
                                                        'post',
                                                        'page'
                                                    );
                           
            function __construct()
                {
                    global $woo_multidomain;
                    
                    $this->functions        =   $woo_multidomain->functions;
                    $this->woomd_network    =   $woo_multidomain->functions->network;
                    
                    add_filter ( 'save_post' ,      array ( $this, 'save_post' ),       10, 3 );
                                                    
                    add_filter ( 'posts_where' ,    array ( $this, 'posts_where' ),     -1, 2 );
                    
                    add_filter ( 'wp_count_posts' , array ( $this, 'wp_count_posts' ),  99, 3 );
                    
                }
                
           
            function save_post ( $post_ID, $post, $update )
                {
                    
                    if ( ! in_array ( $post->post_type, self::$seek_post_types ) )
                        return;       
                    
                    global $blog_id;
                    
                    update_post_meta ( $post_ID, 'woomd_site_id', $blog_id );
                }
           
           
           
            function posts_where ( $where, $wp_query )
                {
                    $query_post_types = ( isset( $wp_query->query_vars['post_type'] ) && ! empty ( $wp_query->query_vars['post_type'] ) ) ? $wp_query->query_vars['post_type'] :   (  ( isset( $wp_query->query['post_type'] ) && ! empty ( $wp_query->query['post_type'] ) ) ?   $wp_query->query['post_type']  :   "" );
                    
                    if ( empty ( $query_post_types ) && $wp_query->is_tax( 'product_cat' ) )
                        $query_post_types   =   'product';
                    
                    if ( empty ( $query_post_types ) )
                        $query_post_types   =   'post';    
                        
                    if ( empty ( $query_post_types )   
                        ||  ( is_array( $query_post_types ) && count ( array_intersect( self::$seek_post_types, $query_post_types )  ) < 1  )
                        ||  ( is_string( $query_post_types )  &&  ! in_array( $query_post_types, self::$seek_post_types ) )
                        )
                        return $where;
                        
                    global $blog_id, $wpdb;
                    
                    $include_IDs    =   self::get_objects_to_include( $blog_id );
                         
                    $post__in = implode( ',', array_map( 'absint', $include_IDs ) );
                    $where   .= " AND {$wpdb->posts}.ID IN ($post__in)";
                    
                    return $where;   
                    
                }
                
                
                
            public static function get_objects_to_include( $blog_id, $IfEmptyIncludeFalseID = TRUE )
                {
                    $objects_ids = wp_cache_get( 'woomd/general-content/objects_to_include/' . $blog_id );
                    
                    if ( $objects_ids === FALSE )
                        {
                            global $wpdb;
                            
                            $mysql_query    =   $wpdb->prepare ( "SELECT post_id FROM " . $wpdb->postmeta . " WHERE `meta_key` =   'woomd_site_id' AND `meta_value` = %s", $blog_id );
                            
                            $results        =   $wpdb->get_results ( $mysql_query );
                            
                            $objects_ids    =   array ();
                        
                            foreach ( $results  as  $result)
                                $objects_ids[]  =   $result->post_id;
                                
                            //exclude woocommerce pages
                            $include_pages   =   array();
                            $include_pages[]         =   get_option( 'woocommerce_shop_page_id' );
                            $include_pages[]         =   get_option( 'woocommerce_cart_page_id' );
                            $include_pages[]         =   get_option( 'woocommerce_checkout_page_id' );
                            $include_pages[]         =   get_option( 'woocommerce_myaccount_page_id' );
                            $include_pages[]         =   get_option( 'woocommerce_terms_page_id' );
                            //$include_pages[]         =   get_option( 'woocommerce_refund_returns_page_id' );
                            
                            $include_pages  =   array_filter ( $include_pages );
                            
                            foreach  ( $include_pages   as  $include_page )
                                {
                                    if ( array_search ( $include_page, $objects_ids ) === FALSE ) 
                                        $objects_ids[]  =   $include_page;
                                }
                                
                            wp_cache_set( 'woomd/general-content/objects_to_include/' . $blog_id, $objects_ids );
                        }
                             
                    if (    $IfEmptyIncludeFalseID  === TRUE  &&  count ( $objects_ids ) < 1 ) 
                        $objects_ids[]  =   0;
                        
                    return $objects_ids;
                }
         
         
         
            function wp_count_posts ( $counts, $type, $perm )
                {
                    
                    if ( ! in_array ( $type, self::$seek_post_types ) )
                        return $counts;
                        
                    global $wpdb;
            
                    $cache_key = _count_posts_cache_key( $type, $perm );

                    $counts = wp_cache_get( 'woomd-' . $cache_key, 'counts' );
                    if ( false !== $counts ) {
                        // We may have cached this before every status was registered.
                        foreach ( get_post_stati() as $status ) {
                            if ( ! isset( $counts->{$status} ) ) {
                                $counts->{$status} = 0;
                            }
                        }

                        return $counts;
                    }

                    $query = "SELECT post_status, COUNT( * ) AS num_posts FROM {$wpdb->posts} WHERE post_type = %s";

                    if ( 'readable' === $perm && is_user_logged_in() ) {
                        $post_type_object = get_post_type_object( $type );
                        if ( ! current_user_can( $post_type_object->cap->read_private_posts ) ) {
                            $query .= $wpdb->prepare(
                                " AND (post_status != 'private' OR ( post_author = %d AND post_status = 'private' ))",
                                get_current_user_id()
                            );
                        }
                    }
                    
                    global $blog_id;
                    
                    $include_IDs    =   $this->get_objects_to_include( $blog_id );
                    
                    $post__in = implode( ',', array_map( 'absint', $include_IDs ) );
                    $query   .= " AND {$wpdb->posts}.ID IN ($post__in)";

                    $query .= ' GROUP BY post_status';

                    $results = (array) $wpdb->get_results( $wpdb->prepare( $query, $type ), ARRAY_A );
                    $counts  = array_fill_keys( get_post_stati(), 0 );

                    foreach ( $results as $row ) {
                        $counts[ $row['post_status'] ] = $row['num_posts'];
                    }

                    $counts = (object) $counts;
                    wp_cache_set( 'woomd-' . $cache_key, $counts, 'counts' );

                    return $counts;
                    
                }
                
        }

    new Woo_General_Content();

?>