<?php



        add_filter('pre_cache_alloptions', 'woomd__pre_cache_alloptions',    999);
        /**
        * Pre cache all options processing
        * 
        * @param mixed $alloptions
        */
        function woomd__pre_cache_alloptions( $alloptions )
            {
                global $wpdb, $blog_id;
                
                //if on main domain, just return the options
                if  ( empty($blog_id)   ||  $blog_id < 2 )
                    return $alloptions;
                
                if ( WOOMD_OPTIONS_SETUP_TYPE === 1 )
                    return $alloptions;  
                
                if ( WOOMD_OPTIONS_SETUP_TYPE === 2 )
                    {
                        $alloptions_db = $wpdb->get_results( "SELECT option_name, option_value FROM $wpdb->options" );
                        $alloptions = array();
                        foreach ( (array) $alloptions_db as $o ) 
                            {
                                $alloptions[ $o->option_name ] = $o->option_value;
                            }
                        
                        //load specific options from main site
                        $main_domain_options    =   $wpdb->get_results( "SELECT option_name, option_value FROM " . $wpdb->base_prefix . "options" );
                        
                        foreach ( $main_domain_options   as     $option_block )
                            {
                                if ( woomd__option_regex( $option_block->option_name ) &&  ! isset( $alloptions[ $option_block->option_name ] ))
                                    $alloptions[ $option_block->option_name ] =   $option_block->option_value;
                                    
                                if  ( woomd__option_regex( $option_block->option_name )  === FALSE )
                                    $alloptions[ $option_block->option_name ] =   $option_block->option_value;
                                
                            }
                        
                    }
                
                return $alloptions;
                
            }
        
        
        add_action( 'update_option', 'woomd__update_option', 999, 3);
        /**
        * Ensure the option exists temporary, until being updated on the main update_option function
        * 
        * @param mixed $option
        * @param mixed $old_value
        * @param mixed $value
        */
        function woomd__update_option ( $option, $old_value, $value )
            {
                global $wpdb, $blog_id;
                
                //if on main domain, just return the options
                if  ( empty($blog_id)   ||  $blog_id < 2 )
                    return;
                    
                //Nothing to do on this set-up, the option has been ssave in the right table
                if ( WOOMD_OPTIONS_SETUP_TYPE === 1 )
                    return;
                    
                if ( WOOMD_OPTIONS_SETUP_TYPE === 2 )
                    {
                        //ensure th option is not there already
                        $row = $wpdb->get_row( $wpdb->prepare( "SELECT option_value FROM $wpdb->options WHERE option_name = %s LIMIT 1", $option ) );
                        
                        //if already found return
                        if ( is_object( $row ) )
                            return;

                        $serialized_value = maybe_serialize( $old_value );
                        $result = $wpdb->query( $wpdb->prepare( "INSERT INTO `$wpdb->options` (`option_name`, `option_value`, `autoload`) VALUES (%s, %s, %s)", $option, $serialized_value, 'no' ) );
                    }    
                    
            }
        
        
        add_action( 'updated_option', 'woomd__updated_option', 999, 3 );
        /**
        * Ensure the option is being saved in the right options table
        * 
        * @param mixed $option
        * @param mixed $old_value
        * @param mixed $value
        */
        function woomd__updated_option( $option, $old_value, $value )
            {
                global $blog_id;
                
                //if on main domain, just return the options
                if  ( empty($blog_id)   ||  $blog_id < 2 )
                    return;
                
                //Nothing to do on this set-up, the option has been ssave in the right table
                if ( WOOMD_OPTIONS_SETUP_TYPE === 1 )
                    return;
                    
                if ( WOOMD_OPTIONS_SETUP_TYPE === 2 )
                    {
                        //We need to push the option to main domain, unless option name is being ignord
                        if  ( woomd__option_regex( $option ) )
                            return;
                            
                        //delete from this domain
                        delete_option( $option );
                        
                        //update on main blog
                        $network_class_instance =   new Woo_MultiDomain_Network();
                        $network_class_instance->switch_to_domain( 1 );
                                          
                        update_option( $option, $value );
                        
                        $network_class_instance->restore_current_domain();
                        
                        $network_class_instance->reload_alloptions();
                        
                    }    
                
            }
            
            
        /**
        * Regex match the option name
        *     
        * @param mixed $option_name
        */
        function woomd__option_regex( $option_name )
            {
                                
                foreach ( Woo_MultiDomain_Functions::get_ignore_options()  as $ignore_option )
                    {
                        $gobal_pre      =   substr( $ignore_option , 0, 1) === '%'  ?   TRUE    :   FALSE;
                        $gobal_post     =   substr( $ignore_option , -1) === '%'    ?   TRUE    :   FALSE;
                        
                        $ignore_option  =   str_replace( '%', '', $ignore_option );
                        
                        if  ( ! $gobal_pre )
                            $ignore_option  =   '^' . $ignore_option;    
                            
                        if  ( ! $gobal_post )
                            $ignore_option  .=   '$';
                        
                        if ( preg_match( '/' . $ignore_option  . '/i', $option_name ) )
                            return TRUE;
                    }
                    
                return FALSE;
                
            }