<?php
/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://wpswings.com/
 * @since      3.0.0
 *
 * @package    Wordpress_Pdf_Generator
 * @subpackage Wordpress_Pdf_Generator/admin/partials
 */

if ( ! defined( 'ABSPATH' ) ) {

	exit(); // Exit if accessed directly.
}
global $pgfw_mwb_pgfw_obj, $wpg_mwb_wpg_obj;
$pgfw_active_tab        = isset( $_GET['pgfw_tab'] ) ? sanitize_key( $_GET['pgfw_tab'] ) : 'wordpress-pdf-generator-layout-settings'; // phpcs:ignore WordPress.Security.NonceVerification
$pgfw_default_tabs      = $pgfw_mwb_pgfw_obj->mwb_pgfw_plug_layout_setting_sub_tabs();
$wpg_cover_setting_html = apply_filters( 'wpg_layout_cover_page_setting_html_array', array() );
?>
<main class="mwb-main mwb-bg-white mwb-r-8">
	<nav class="mwb-navbar">
		<ul class="mwb-navbar__items">
			<?php
			if ( is_array( $pgfw_default_tabs ) && ! empty( $pgfw_default_tabs ) ) {

				foreach ( $pgfw_default_tabs as $pgfw_tab_key => $pgfw_default_tabs ) {

					$pgfw_tab_classes = 'mwb-link ';
					if ( ! empty( $pgfw_active_tab ) && $pgfw_active_tab === $pgfw_tab_key ) {
						$pgfw_tab_classes .= 'active';
					} elseif ( 'wordpress-pdf-generator-layout-settings' === $pgfw_active_tab ) {
						if ( 'wordpress-pdf-generator-cover-page-setting' === $pgfw_tab_key ) {
							$pgfw_tab_classes .= 'active';
						}
					}
					?>
					<li>
						<a id="<?php echo esc_attr( $pgfw_tab_key ); ?>" href="<?php echo esc_url( admin_url( 'admin.php?page=pdf_generator_for_wp_menu' ) . '&pgfw_tab=' . esc_attr( $pgfw_tab_key ) ); ?>" class="<?php echo esc_attr( $pgfw_tab_classes ); ?>"><?php echo esc_html( $pgfw_default_tabs['title'] ); ?></a>
					</li>
					<?php
				}
			}
			?>
		</ul>
	</nav>
	<section class="mwb-section">
		<div>
			<form action="" method="POST" class="mwb-pgfw-gen-section-form">
				<div class="pgfw-secion-wrap">
					<?php
					require_once WORDPRESS_PDF_GENERATOR_DIR_PATH . 'admin/partials/wordpress-pdf-generator-layout-table.php';
					wp_nonce_field( 'nonce_settings_save', 'wpg_nonce_field' );
					$wpg_mwb_wpg_obj->mwb_wpg_plug_generate_html( $wpg_cover_setting_html );
					?>
				</div>
			</form>
		</div>
	</section>
