<?php
/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://wpswings.com/
 * @since             1.0.0
 * @package           Wordpress_Pdf_Generator
 *
 * @wordpress-plugin
 * Plugin Name:       WordPress PDF Generator
 * Plugin URI:        https://wpswings.com/product/pdf-generator-for-wp-pro/?utm_source=wpswings-pdf-product&utm_medium=pdf-pro-backend&utm_campaign=product-page
 * Description:       WordPress PDF Generator assists you in converting your pages, products, or posts into PDF format, enabling easy sharing across channels and offline access.
 * Version:           3.0.4
 * Author:            WP Swings
 * Author URI:        https://wpswings.com/?utm_source=wpswings-official&utm_medium=pdf-pro-backend&utm_campaign=official
 * Text Domain:       wordpress-pdf-generator
 * Domain Path:       /languages
 *
 * Requires at least:    4.6
 * Tested up to:         5.9
 * WC requires at least: 4.0.0
 * WC tested up to:      6.1.1
 * Stable tag:           3.0.4
 * Requires PHP:         7.2
 * License:              Software License Agreement
 * License URI:          https://wpswings.com/license-agreement.txt
 */

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	die;
}

$active_plugins = array_merge( get_option( 'active_plugins', array() ), get_site_option( 'active_sitewide_plugins', array() ) );
if ( in_array( 'pdf-generator-for-wp/pdf-generator-for-wp.php', $active_plugins, true ) || array_key_exists( 'pdf-generator-for-wp/pdf-generator-for-wp.php', $active_plugins ) ) {
	mwb_wpg_run_current_plugin();
} else {
	wpg_dependency_checkup();
}
/**
 * Checking dependency for woocommerce plugin.
 *
 * @return void
 */
function wpg_dependency_checkup() {
	add_action( 'admin_init', 'wpg_deactivate_child_plugin' );
	add_action( 'admin_notices', 'wpg_show_admin_notices' );
}
/**
 * Deactivating child plugin.
 *
 * @return void
 */
function wpg_deactivate_child_plugin() {
	deactivate_plugins( plugin_basename( __FILE__ ) );
}
/**
 * Showing admin notices.
 *
 * @since 3.0.0
 * @return void
 */
function wpg_show_admin_notices() {
	require_once 'mwb-wpg-auto-download-free.php';
	mwb_wpg_run_current_plugin();
	$response_free_download = wpg_replace_plugin();
	if ( ! $response_free_download ) {
		$wpg_child_plugin  = __( 'WordPress PDF Generator', 'wordpress-pdf-generator' );
		$wpg_parent_plugin = __( 'PDF Generator for Wp', 'wordpress-pdf-generator' );
		echo '<div class="notice notice-error is-dismissible"><p>'
			/* translators: %s dependency checks */
			. sprintf( esc_html__( '%1$s requires %2$s to function correctly. Please activate %2$s before activating %1$s. For now, the plugin has been deactivated.', 'wordpress-pdf-generator' ), '<strong>' . esc_html( $wpg_child_plugin ) . '</strong>', '<strong>' . esc_html( $wpg_parent_plugin ) . '</strong>' )
			. '</p></div>';
		if ( isset( $_GET['activate'] ) ) { // phpcs:ignore
			unset( $_GET['activate'] ); //phpcs:ignore
		}
	}
}

// ================================= Plugin Main Functions ================================

/**
 * Define plugin constants.
 *
 * @since 3.0.0
 */
function define_wordpress_pdf_generator_constants() {
	wordpress_pdf_generator_constants( 'WORDPRESS_PDF_GENERATOR_VERSION', '3.0.4' );
	wordpress_pdf_generator_constants( 'WORDPRESS_PDF_GENERATOR_DIR_PATH', plugin_dir_path( __FILE__ ) );
	wordpress_pdf_generator_constants( 'WORDPRESS_PDF_GENERATOR_DIR_URL', plugin_dir_url( __FILE__ ) );
	wordpress_pdf_generator_constants( 'WORDPRESS_PDF_GENERATOR_SERVER_URL', 'https://wpswings.com' );
	wordpress_pdf_generator_constants( 'WORDPRESS_PDF_GENERATOR_ITEM_REFERENCE', 'WordPress PDF Generator' );
}

/**
 * Callable function for defining plugin constants.
 *
 * @param string $key    Key for contant.
 * @param string $value   value for contant.
 * @since   3.0.0
 */
function wordpress_pdf_generator_constants( $key, $value ) {
	if ( ! defined( $key ) ) {
		define( $key, $value );
	}
}

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-wordpress-pdf-generator-activator.php
 *
 * @param boolean $network_wide either network activated or not.
 * @since 3.0.0
 * @return void
 */
function activate_wordpress_pdf_generator( $network_wide ) {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-wordpress-pdf-generator-activator.php';
	WordPress_Pdf_Generator_Activator::wordpress_pdf_generator_activate( $network_wide );
	$mwb_wpg_active_plugin                            = get_option( 'mwb_all_plugins_active', array() );
	$mwb_wpg_active_plugin['wordpress-pdf-generator'] = array(
		'plugin_name' => __( 'WordPress PDF Generator', 'wordpress-pdf-generator' ),
		'active'      => '1',
	);
	update_option( 'mwb_all_plugins_active', $mwb_wpg_active_plugin );
	if ( ! wp_next_scheduled( 'mwb_wpg_check_license_daily' ) ) {
		wp_schedule_event( time(), 'daily', 'mwb_wpg_check_license_daily' );
	}
}

/**
 * Update default values on new site creation.
 *
 * @param object $new_site current new blog object.
 * @since 3.0.2
 * @return void
 */
function mwb_wpg_update_option_value_new_site_creation( $new_site ) {
	if ( ! function_exists( 'is_plugin_active_for_network' ) ) {
		require_once ABSPATH . '/wp-admin/includes/plugin.php';
	}
	if ( is_plugin_active_for_network( 'wordpress-pdf-generator/wordpress-pdf-generator.php' ) ) {
		$blog_id            = $new_site->blog_id;
		$mwb_license_code   = get_option( 'mwb_wpg_license_key' );
		$mwb_license_status = get_option( 'mwb_wpg_license_check' );
		switch_to_blog( $blog_id );
		update_option( 'mwb_wpg_license_key', $mwb_license_code );
		update_option( 'mwb_wpg_license_check', $mwb_license_status );
		require_once plugin_dir_path( __FILE__ ) . 'includes/class-wordpress-pdf-generator-activator.php';
		WordPress_Pdf_Generator_Activator::wpg_create_database_table_on_activation();
		WordPress_Pdf_Generator_Activator::wpg_update_option_table_for_pro_settings();
		$mwb_wpg_active_plugin                            = get_option( 'mwb_all_plugins_active', array() );
		$mwb_wpg_active_plugin['wordpress-pdf-generator'] = array(
			'plugin_name' => __( 'WordPress PDF Generator', 'wordpress-pdf-generator' ),
			'active'      => '1',
		);
		update_option( 'mwb_all_plugins_active', $mwb_wpg_active_plugin );
		if ( ! wp_next_scheduled( 'mwb_wpg_check_license_daily' ) ) {
			wp_schedule_event( time(), 'daily', 'mwb_wpg_check_license_daily' );
		}
		restore_current_blog();
	}
}

add_action( 'wp_initialize_site', 'mwb_wpg_update_option_value_new_site_creation', 900 );

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-wordpress-pdf-generator-deactivator.php
 */
function deactivate_wordpress_pdf_generator() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-wordpress-pdf-generator-deactivator.php';
	WordPress_Pdf_Generator_Deactivator::wordpress_pdf_generator_deactivate();
	$mwb_wpg_deactive_plugin = get_option( 'mwb_all_plugins_active', false );
	if ( is_array( $mwb_wpg_deactive_plugin ) && ! empty( $mwb_wpg_deactive_plugin ) ) {
		foreach ( $mwb_wpg_deactive_plugin as $mwb_wpg_deactive_key => $mwb_wpg_deactive ) {
			if ( 'wordpress-pdf-generator' === $mwb_wpg_deactive_key ) {
				$mwb_wpg_deactive_plugin[ $mwb_wpg_deactive_key ]['active'] = '0';
			}
		}
	}
	update_option( 'mwb_all_plugins_active', $mwb_wpg_deactive_plugin );
}

/**
 * Auto update function from WP Swings site.
 *
 * @since 3.0.0
 * @return void
 */
function auto_update_wordpress_pdf_generator() {
	$mwb_wpg_license_key = get_option( 'mwb_wpg_license_key', '' );
	wordpress_pdf_generator_constants( 'WORDPRESS_PDF_GENERATOR_SPECIAL_SECRET_KEY', '59f32ad2f20102.74284991' );
	wordpress_pdf_generator_constants( 'WORDPRESS_PDF_GENERATOR_LICENSE_SERVER_URL', 'https://wpswings.com' );
	wordpress_pdf_generator_constants( 'WORDPRESS_PDF_GENERATOR_ITEM_REFERENCE', 'WordPress PDF Generator' );
	wordpress_pdf_generator_constants( 'WORDPRESS_PDF_GENERATOR_BASE_FILE', __FILE__ );
	wordpress_pdf_generator_constants( 'WORDPRESS_PDF_GENERATOR_LICENSE_KEY', $mwb_wpg_license_key );
	require_once 'class-mwb-wordpress-pdf-generator-update.php';
}

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since 3.0.0
 */
function run_wordpress_pdf_generator() {
	define_wordpress_pdf_generator_constants();
	auto_update_wordpress_pdf_generator();
	$wpg_plugin_standard = new WordPress_Pdf_Generator();
	$wpg_plugin_standard->wpg_run();
	$GLOBALS['wpg_mwb_wpg_obj'] = $wpg_plugin_standard;
}

/**
 * Settings link.
 *
 * @since 3.0.0
 * @param array $links Settings link array.
 */
function wordpress_pdf_generator_settings_link( $links ) {
	$my_link = array(
		'<a href="' . admin_url( 'admin.php?page=pdf_generator_for_wp_menu' ) . '">' . __( 'Settings', 'wordpress-pdf-generator' ) . '</a>',
	);
	return array_merge( $my_link, $links );
}

/**
 * Adding custom setting links at the plugin activation list.
 *
 * @param array  $links_array array containing the links to plugin.
 * @param string $plugin_file_name plugin file name.
 * @return array
 */
function wordpress_pdf_generator_custom_settings_at_plugin_tab( $links_array, $plugin_file_name ) {
	if ( strpos( $plugin_file_name, basename( __FILE__ ) ) ) {
		$links_array[] = '<a href="https://demo.wpswings.com/wordpress-pdf-generator-pro/?utm_source=wpswings-pdf-demo&utm_medium=pdf-pro-backend&utm_campaign=view-demo" target="_blank"><img src="' . esc_html( WORDPRESS_PDF_GENERATOR_DIR_URL ) . 'admin/src/images/Demo.svg" class="mwb-info-img" alt="Demo image" style="width: 20px;height: 20px;padding-right:2px;">' . __( 'Demo', 'wordpress-pdf-generator' ) . '</a>';
		$links_array[] = '<a href="https://docs.wpswings.com/wordpress-pdf-generator-pro/?utm_source=wpswings-pdf-docs&utm_medium=pdf-pro-backend&utm_campaign=documentation" target="_blank"><img src="' . esc_html( WORDPRESS_PDF_GENERATOR_DIR_URL ) . 'admin/src/images/Documentation.svg" class="mwb-info-img" alt="documentation image" style="width: 20px;height: 20px;padding-right:2px;">' . __( 'Documentation', 'wordpress-pdf-generator' ) . '</a>';
		$links_array[] = '<a href="https://support.wpswings.com/?utm_source=wpswings-pdf-support&utm_medium=pdf-pro-backend&utm_campaign=support" target="_blank"><img src="' . esc_html( WORDPRESS_PDF_GENERATOR_DIR_URL ) . 'admin/src/images/Support.svg" class="mwb-info-img" alt="support image" style="width: 20px;height: 20px;padding-right:2px;">' . __( 'Support', 'wordpress-pdf-generator' ) . '</a>';
	}
	return $links_array;
}


/**
 * Run current plugin all hooks.
 *
 * @since 3.0.1
 * @return void
 */
function mwb_wpg_run_current_plugin() {
	register_activation_hook( __FILE__, 'activate_wordpress_pdf_generator' );
	register_deactivation_hook( __FILE__, 'deactivate_wordpress_pdf_generator' );
	/**
	 * The core plugin class that is used to define internationalization,
	 * admin-specific hooks, and public-facing site hooks.
	 */
	require plugin_dir_path( __FILE__ ) . 'includes/class-wordpress-pdf-generator.php';

	run_wordpress_pdf_generator();

	// Add settings link on plugin page.
	add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), 'wordpress_pdf_generator_settings_link' );
	add_filter( 'plugin_row_meta', 'wordpress_pdf_generator_custom_settings_at_plugin_tab', 10, 2 );
}
// Upgrade notice code.

add_action( 'after_plugin_row_' . plugin_basename( __FILE__ ), 'mwb_pro_pdf_upgrade_notice', 0, 3 );

/**
 * Displays notice to upgrade to membership pro.
 *
 * @param string $plugin_file Path to the plugin file relative to the plugins directory.
 * @param array  $plugin_data An array of plugin data.
 * @param string $status Status filter currently applied to the plugin list.
 */
function mwb_pro_pdf_upgrade_notice( $plugin_file, $plugin_data, $status ) {

	?>

		<tr class="plugin-update-tr active notice-warning notice-alt">
			<td colspan="4" class="plugin-update colspanchange">
				<div class="notice notice-success inline update-message notice-alt">
					<div class='wps-notice-title wps-notice-section'>
						<p><strong><?php esc_html_e( 'IMPORTANT NOTICE:', 'wordpress-pdf-generator' ); ?></strong></p>
					</div>
					<div class='wps-notice-content wps-notice-section'>
						<p><?php esc_html_e( 'From this update', 'wordpress-pdf-generator' ); ?><strong><?php esc_html_e( ' Version 3.0.4', 'wordpress-pdf-generator' ); ?></strong><?php esc_html_e( ' onwards, the plugin and its support will be handled by', 'wordpress-pdf-generator' ); ?><strong><?php esc_html_e( ' WP Swings', 'wordpress-pdf-generator' ); ?></strong>.</p><p><strong><?php esc_html_e( 'WP Swings', 'wordpress-pdf-generator' ); ?></strong><?php esc_html_e( ' is just our improvised and rebranded version with all quality solutions and help being the same, so no worries at your end.', 'wordpress-pdf-generator' ); ?>
						<?php esc_html_e( 'Please connect with us for all setup, support, and update related queries without hesitation.', 'wordpress-pdf-generator' ); ?></p>
					</div>
				</div>
			</td>
		</tr>
		<style>
			.wps-notice-section > p:before {
				content: none;
			}
		</style>

	<?php

}
// Ending noticed code .
