<?php

/*
 * Plugin Name: AF2A Addons
 * Description: Personnalise l'affichage des pages produits et de paiement : Nécessite les plugins : Woocommerce, Advanced Product Fields for Woocommerce
 * Version: 1.0.1
 * Author: Agent 3W
 * Author URI: https://agent3w.com
 * Text Domain: agent3w-af2a
 * Domain Path: /languages
 * WC requires at least: 3.4.0
 * WC tested up to: 5.7
 */

if( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

if ( ! function_exists('A3w_AF2A_Autoloader') ) {
    function A3w_AF2A_Autoloader( $class_name ) {
        // Not loading a class from our plugin.
        if ( ! is_int( strpos( $class_name, 'Agent3w\Af2a' ) ) ) {
            return;
        }
        // Remove root namespace as we don't have that as a folder.
        $class_name = str_replace( 'Agent3w\Af2a\\', '', $class_name );
        $class_name = str_replace( '\\', '/', strtolower( $class_name ) ) . '.php';
        // Get only the file name.
        $pos       = strrpos( $class_name, '/' );
        $file_name = is_int( $pos ) ? substr( $class_name, $pos + 1 ) : $class_name;
        // Get only the path.
        $path = str_replace( $file_name, '', $class_name );
        // Construct file path.
        $file_path = plugin_dir_path( __FILE__ ) . str_replace( '\\', DIRECTORY_SEPARATOR, $path . strtolower( $file_name ) );

        if ( file_exists( $file_path ) ) {
            require_once( $file_path );
        }
    }

    spl_autoload_register( 'A3w_AF2A_Autoloader' );
}

if( ! function_exists('agent3w_af2a_init') ) {
    function agent3w_af2a_init() {
        // globals
        global $agent3w_af2a;
        $plugin_const = [
            'plugin_dir' => plugin_dir_path(__FILE__),
            'plugin_dir_url' => plugin_dir_url(__FILE__),
        ];

        // initialize
        if ( ! isset( $agent3w_af2a ) ) {
            $agent3w_af2a = new \Agent3w\Af2a\Inc\agent3w_af2a($plugin_const);
            $agent3w_af2a->run();
        }

        return $agent3w_af2a;

    }
    // initialize
    agent3w_af2a_init();
}

/* OPTIONS DU PLUGIN
**********************/
define('AF2A_OPTION_ADDON_WAPF', true); // true|false : true = active la surcouche du plugin Advanced Product Fields Pro for WooCommerce (default = true)
define('AF2A_OPTION_WC_OVERRIDE_TEMPLATES', true); // true|false : true = active l'override des templates woocommerce dans le plugin (default = true)
define('AF2A_OPTION_WC_TRIER_LES_COMMANDES', true); // true|false : true = trie les commandes dans les résumés de commande (sépare les précommandes) (default = true)
define('AF2A_OPTION_WC_PRECO_AVANT_PAYANT', true); // true|false : true = place les précommandes avant les payantes (default = true)
define('AF2A_OPTION_WC_AFFICHER_QUANTITE', false); // true|false : true = affiche la quantité dans les résumés de commande (default = false)
define('AF2A_OPTION_TEXT_BOUTON_INSCRIPTION', ''); // texte personnalisé optionnel (default = Inscrire le ou les participants)
define('AF2A_OPTION_TEXT_BOUTON_MODIF_INSCRIPTION', ''); // texte personnalisé optionnel (default = Modifier la liste des participants)
define('AF2A_OPTION_TEXT_PANIER_TITRE_PRECOMMANDE', ''); // texte personnalisé du titre des précommandes dans la page panier (default = Précommande)
define('AF2A_OPTION_TEXT_PANIER_TITRE_PAYANT', ''); // texte personnalisé du titre des commandes payantes dans la page panier (default = Paiement à la commande)
define('AF2A_OPTION_TEXT_PAIEMENT_TITRE_PRECOMMANDE', ''); // texte personnalisé du titre des précommandes dans la page de paiement (default = Précommande)
define('AF2A_OPTION_TEXT_PAIEMENT_TITRE_PAYANT', ''); // texte personnalisé du titre des commandes payantes dans la page de paiement (default = Payable immédiatement)
define('AF2A_OPTION_TEXT_CONFIRMATION_TITRE_PRECOMMANDE', ''); // texte personnalisé du titre des précommandes dans la page de confirmation (default = Précommandé)
define('AF2A_OPTION_TEXT_CONFIRMATION_TITRE_PAYANT', ''); // texte personnalisé du titre des commandes payantes dans la page de confirmation (default = Payé)
define('AF2A_OPTION_WAPF_WCPRODUCT_CSS', true); // true|false : true = charge le CSS lié aux modifs Advanced Product Fields Pro for WooCommerce sur la page produit (default = true)
define('AF2A_OPTION_WAPF_WCCART_CSS', AF2A_OPTION_WC_AFFICHER_QUANTITE); // true|false : true = charge le CSS lié aux modifs Advanced Product Fields Pro for WooCommerce sur la page panier (default = true)
