<?php   
        
        if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
        
        $licence_data   =   $this->licence->get_licence_data();
?>

            <div id="form_data">
                    <h1><?php _e( "Licence", 'woo-multidomain' ) ?></h1>
                    <form name="form" method="post">    
                        <?php wp_nonce_field('woomd_licence','woomd_license_nonce'); ?>
                        <input type="hidden" name="woomd_licence_form_submit" value="true" />
                        <input type="hidden" name="woomd_licence_deactivate" value="true" />

                        <div class="start-container licence-key">
                            <div class="text">
                
                                <h2>License Key</h2>
                                <div class="option">
                                    <div class="controls">
                                        <p><b><?php echo substr($licence_data['key'], 0, 20) ?>-xxxxxxxx-xxxxxxxx</b> &nbsp;&nbsp;&nbsp;<a class="button-secondary" title="Deactivate" href="javascript: void(0)" onclick="jQuery(this).closest('form').submit();"><?php _e( "Deactivate", 'woo-multidomain' ) ?></a></p>
                                    </div>
                                    <div class="explain"><?php _e( "You can generate more keys at ", 'woo-multidomain' ) ?> <a href="https://woomultidomain.com/my-account/" target="_blank"><?php _e( "My Account", 'woo-multidomain' ) ?></a></div>
                                </div>
                                
                                <?php
                                    
                                    if ( isset( $licence_data ) &&  ! empty ( $licence_data['licence_status'] ) )
                                        {
                                            ?><br /><p><?php _e( "License Status", 'woo-multidomain' ) ?>: <b><?php echo ucfirst( __( $licence_data['licence_status'], 'woo-multidomain' ) ); ?></b></p><?php   
                                        }
                                
                                    if ( isset( $licence_data ) &&  ! empty ( $licence_data['licence_expire'] ) )
                                        {
                                            ?><p><?php _e( "License Expiration", 'woo-multidomain' ) ?>: <b><?php echo date_i18n( get_option( 'date_format' ), strtotime( $licence_data['licence_expire'] ) ); ?></b><?php
                                            
                                                if  ( strtotime( $licence_data['licence_expire'] )  <   strtotime( date('Y-m-d') ) )
                                                    {
                                                        ?> &nbsp;&nbsp;&nbsp;&nbsp;<span class="warning"><?php _e( "Licence is expired, plugin <b>Updates</b> and <b>Support</b> are not available", 'woo-multidomain' ) ?>.</span><?php
                                                    } 
                                            
                                            ?></p><?php   
                                        }
                                        
                                    if ( isset( $licence_data ) &&  ! empty ( $licence_data['_sl_new_version'] ) )
                                        {
                                            global $woo_multidomain;
                                            
                                            $plugin_data    =   $woo_multidomain->functions->get_plugin_data( WOOMULTID_PATH . '/woocommerce-miltidomain.php', $markup = true, $translate = true );
                                            $deployed_plugin_verson =   isset ( $plugin_data['Version'] )   ?   $plugin_data['Version'] :   '';
                                            
                                            if (  ! empty ( $deployed_plugin_verson )    &&  version_compare( $deployed_plugin_verson, $licence_data['_sl_new_version'], "<")) 
                                                {
                                            
                                                    ?><p><?php _e( "New plugin version available", 'woo-multidomain' ) ?>: <b><?php echo $licence_data['_sl_new_version']; ?></b></p><?php   
                                                }
                                        }
                                ?>
                            </div>
                        </div>
                    </form>
    
            </div>