<?php

    if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
    
    class WooMD_Settings
        {
            var $functions;
            var $woomd_network;
            
            var $wp_list_table;
            
            var $current_section;
            
            var $licence;
            
            function __construct()
                {
                    global $woo_multidomain;
                    
                    $this->functions        =   $woo_multidomain->functions;
                    $this->woomd_network    =   $woo_multidomain->functions->network;   
                    
                    $this->licence          =   $woo_multidomain->licence;
                                    
                }
                
            
            function init()
                {      
                    $this->run();
                   
                    $this->admin_notices();
                   
                    $this->output();
                }
                
            
            static public function admin_print_styles()
                {
                    
                    wp_register_style('WooMD_general-options', WOOMULTID_URL . '/assets/css/general-options.css');
                    wp_enqueue_style( 'WooMD_general-options');   
                }
                
            static public function admin_print_scripts()
                {
                    $WC_url     =   plugins_url() . '/woocommerce';
                    
                    wp_register_script( 'jquery-tiptip', $WC_url . '/assets/js/jquery-tiptip/jquery.tipTip.js', array( 'jquery' ), NULL, true );
                    wp_enqueue_script(  'jquery-tiptip');
                    
                    wp_register_script( 'WooMD_options',  WOOMULTID_URL . '/assets/js/woomd-options.js', array( 'jquery' ), NULL, true );
                    wp_enqueue_script(  'WooMD_options'); 
                }
               
            
            static function admin_notices()
                {
                    global $process_interface_save_errors;
                    
                    if ( is_array ( $process_interface_save_errors ) )
                        {
                            foreach ( $process_interface_save_errors    as  $error )
                                {
                                    ?><div class="notice notice-<?php echo $error['type'] ?> settings-error is-dismissible"><p><strong><?php echo $error['message'] ?></strong></p></div><?php   
                                    
                                }
                        
                        
                        }                       
                }
            
            function run()
                {
                    
                    //check for interface licence submit
                    if( isset($_POST['woomd_licence_form_submit']) )
                        {
                            $this->process_interface_licence_save();
                        }
                        
                        
                    if (isset($_POST['woomd_form_submit']))
                        {
                            //check nonce
                            if ( ! wp_verify_nonce($_POST['woomd_form_nonce'],'woomd_form_submit') ) 
                                return;
                            
                            $options    =   $this->functions->get_options();
                            
                            global $woomd_interface_messages;

                            $options['cart_checkout_type']                          =   $_POST['cart_checkout_type'];
                            $options['cart_checkout_location']                      =   $_POST['cart_checkout_location'];
                            
                            $options['hided_products_not_showing_on_domain']        =   isset ( $_POST['hided_products_not_showing_on_domain'] )    &&  $_POST['hided_products_not_showing_on_domain'] == 'yes' ?   'yes'   :   'no';
                            $options['allow_product_different_content']             =   isset ( $_POST['allow_product_different_content'] )    &&  $_POST['allow_product_different_content'] == 'yes' ?   'yes'   :   'no';
                            $options['each_domain_posts_pages_content']             =   isset ( $_POST['each_domain_posts_pages_content'] )    &&  $_POST['each_domain_posts_pages_content'] == 'yes' ?   'yes'   :   'no';
                            $options['load_all_dependencies_through_local_domain']  =   isset ( $_POST['load_all_dependencies_through_local_domain'] )    &&  $_POST['load_all_dependencies_through_local_domain'] == 'yes' ?   'yes'   :   'no';
                                                        
                            $options    =   apply_filters('woomd/options/options_save', $options);
                            
                            //if $options['each_domain_posts_pages_content'] changed, ensure add the required meta field to posts and pages
                            If ( $options['each_domain_posts_pages_content'] == 'yes' )
                                $this->functions->setup_separate_content( array ( 'post', 'page') );
                               
                            $this->functions->update_options( $options );  
                            
                            $woomd_interface_messages[] = array(    'type'  =>   'updated',
                                                                    'text'  =>  __('Settings Saved', 'woo-multidomain'));
                                                                    
                            foreach ($woomd_interface_messages  as  $message)
                                {
                                    echo "<div class='". $message['type'] ." fade'><p>". $message['text']  ."</p></div>";
                                }
              
                        }

                }
                
            
            function process_interface_licence_save()
                {

                    $nonce  =   $_POST['woomd_license_nonce'];
                    if ( ! wp_verify_nonce( $nonce, 'woomd_licence' ) )
                        return FALSE;
                    
                    //only for admins
                    If ( !  current_user_can ( 'manage_options' ) )
                        return FALSE;
                        
                    $screen_slug  =   sanitize_text_field( $_GET['page'] );
                    if(empty($screen_slug))
                        return FALSE;
                    
                    $this->_process_licence( );
        
                }
                
                
                
                            
            private function _process_licence()
                {
                    global $process_interface_save_errors;
                    if ( ! is_array ( $process_interface_save_errors ) )
                        $process_interface_save_errors  =   array ();
                        
                    //check for de-activation
                    if ( isset($_POST['woomd_licence_deactivate']) && wp_verify_nonce($_POST['woomd_license_nonce'],'woomd_licence'))
                        {
                            
                            $licence_data   =   $this->licence->get_licence_data();
                            $licence_key    =   $licence_data['key'];

                            //build the request query
                            $args = array(
                                                'woo_sl_action'         =>  'deactivate',
                                                'licence_key'           =>  $licence_key,
                                                'product_unique_id'     =>  WOOMULTID_PRODUCT_ID,
                                                'domain'                =>  WOOMULTID_INSTANCE
                                            );
                            $request_uri    = WOOMULTID_APP_API_URL . '?' . http_build_query( $args , '', '&');
                            $data           = wp_remote_get( $request_uri );
                            
                            if(is_wp_error( $data ) || $data['response']['code'] != 200)
                                {
                                    $process_interface_save_errors[] =   array(
                                                                                'type'  =>  'error',
                                                                                'message'  =>  __('There was a problem connecting to ', 'woo-multidomain') . WOOMULTID_APP_API_URL );
                                    return;  
                                }
                                
                            $response_block = json_decode($data['body']);
                            $response_block = $response_block[count($response_block) - 1];
                            $response = $response_block->message;
                            
                            if(isset($response_block->status))
                                {
                                    if($response_block->status == 'success' && $response_block->status_code == 's201')
                                        {
                                            //the license is active and the software is active
                                            $process_interface_save_errors[] = array(
                                                                                    'type'  =>  'updated',
                                                                                    'message'  =>  $response_block->message);
                                                                                        
                                            //save the license
                                            $licence_data   =   $this->licence->reset_licence_data( $licence_data );
                                            $licence_data['last_check']   = time();
                                            
                                            $this->licence->update_licence_data( $licence_data );
                                        }
                                        
                                    else //if message code is e104  force de-activation
                                            if ($response_block->status_code == 'e002' || $response_block->status_code == 'e104' || $response_block->status_code == 'e110')
                                                {                                           
                                                    //save the license
                                                    $licence_data   =   $this->licence->reset_licence_data( $licence_data );
                                                    $licence_data['last_check']   = time();
                                                    
                                                    $this->licence->update_licence_data( $licence_data );
                                                }
                                        else
                                        {
                                            $process_interface_save_errors[] =   array(  
                                                                                    'type'  =>  'error',
                                                                                    'message'  =>  __('There was a problem deactivating the licence: ', 'woo-multidomain') . $response_block->message);
                                            
                                            return;
                                        }   
                                }
                                else
                                {
                                    $process_interface_save_errors[] =   array(  
                                                                                    'type'  =>  'error',
                                                                                    'message'  => __('There was a problem with the data block received from ' . WOOMULTID_APP_API_URL, 'woo-multidomain'));
                                    return;
                                }
                                       
                        }   
                    
                    if ( isset($_POST['woomd_licence_activate']) && wp_verify_nonce($_POST['woomd_license_nonce'],'woomd_licence'))
                        {
                            
                            $licence_key = isset($_POST['licence_key'])? sanitize_key(trim($_POST['licence_key'])) : '';

                            if($licence_key == '')
                                {
                                    $process_interface_save_errors[] =   array(  
                                                                                    'type'  =>  'error',
                                                                                    'message'  =>  __("Licence Key can't be empty", 'woo-multidomain'));
                                    
                                    return;
                                }
                                
                            //build the request query
                            $args = array(
                                                'woo_sl_action'         => 'activate',
                                                'licence_key'           => $licence_key,
                                                'product_unique_id'     => WOOMULTID_PRODUCT_ID,
                                                'domain'                => WOOMULTID_INSTANCE
                                            );
                            $request_uri    = WOOMULTID_APP_API_URL . '?' . http_build_query( $args , '', '&');
                            $data           = wp_remote_get( $request_uri );
                            
                            if(is_wp_error( $data ) || $data['response']['code'] != 200)
                                {
                                    $process_interface_save_errors[] =   array(  
                                                                                    'type'  =>  'error',
                                                                                    'message'  =>  __('There was a problem connecting to ', 'woo-multidomain') . WOOMULTID_APP_API_URL );
                                    
                                    return;  
                                }
                                
                            $response_block = json_decode($data['body']);
                            //retrieve the last message within the $response_block
                            $response_block = $response_block[count($response_block) - 1];
                            $response = $response_block->message;
                            
                            if(isset($response_block->status))
                                {
                                    if( $response_block->status == 'success' && ( $response_block->status_code == 's100' || $response_block->status_code == 's101' ) )
                                        {
                                            //the license is active and the software is active
                                            $process_interface_save_errors[] =   array(  
                                                                                    'type'  =>  'updated',
                                                                                    'message'  =>  $response_block->message);
                                            
                                            $licence_data   =   $this->licence->get_licence_data();
                                            
                                            //save the license
                                            $licence_data['key']                = $licence_key;
                                            $licence_data['last_check']         = time();
                                            $licence_data['licence_status']     = isset( $response_block->licence_status ) ?    $response_block->licence_status :   ''  ;
                                            $licence_data['licence_expire']     = isset( $response_block->licence_expire ) ?    $response_block->licence_expire :   ''  ;
                                            
                                            $this->licence->update_licence_data( $licence_data );

                                        }
                                        else
                                        {
                                            $process_interface_save_errors[] =   array(  
                                                                                    'type'  =>  'error',
                                                                                    'message'  =>  __('There was a problem activating the licence: ', 'woo-multidomain') . $response_block->message);                                            
                                            return;
                                        }   
                                }
                                else
                                {
                                    $process_interface_save_errors[] =   array(  
                                                                                    'type'  =>  'error',
                                                                                    'message'  =>  __('There was a problem with the data block received from ' . WOOMULTID_APP_API_URL, 'woo-multidomain'));
                                    
                                    return;
                                }
            
                        }   
                    
                }    
                
                
            function output()
                {
                             
                    $options    =   $this->functions->get_options();
                        
                    ?>
                        <div class="wrap"> 
                            
                            <?php  
            
                                if( !   $this->licence->licence_key_verify() )
                                    include( WOOMULTID_PATH . 'includes/admin/_licence.php' );
                                    else
                                    include( WOOMULTID_PATH . 'includes/admin/_licence_deactivate.php' );
                                    
                            if(  $this->licence->licence_key_verify() )
                                {
                            ?>
                            
                            
                            <h3><?php _e( "General Settings", 'woo-multidomain' ) ?></h3>
                            <form id="form_data" class="options checkout_type_<?php echo $options['cart_checkout_type'] ?>" name="form" method="post">   
                                
                                <h4>Checkout</h4>
                                <table class="form-table">
                                    <tbody>
                                    
                                        <tr id="cart_checkout_type" valign="top">
                                            <th scope="row">
                                                <select name="cart_checkout_type">
                                                    <option value="single_checkout" <?php selected('single_checkout', $options['cart_checkout_type']); ?>><?php _e( "Single Checkout", 'woo-multidomain' ) ?></option>
                                                    <option value="each_store" <?php selected('each_store', $options['cart_checkout_type']); ?>><?php _e( "Each Store", 'woo-multidomain' ) ?></option>
                                                </select>
                                            </th>
                                            <td>
                                                <label><?php _e( "Checkout Type", 'woo-multidomain' ) ?> </label>
                                                <p class="help"><?php _e( "Single Checkout can occur for all cart items, independently from where each product is coming from. In this case the payment will be collected in full amount on the check-out site.", 'woo-multidomain' ) ?></p>
                                                <p class="help"><?php _e( "Selecting Each Store checkout type, the system create individual check-out sessions in shops from where the cart products are belong. Each shop will retrieve the payment separately for their own products", 'woo-multidomain' ) ?></p>
                                            </td>
                                        </tr>
                                    
                                        <tr id="cart_checkout_location" class="hide _show_on_single_checkout" valign="top">
                                            <th scope="row">
                                                <select name="cart_checkout_location">
                                                    <option value="" <?php selected('', $options['cart_checkout_location']); ?>><?php _e( "Any Site", 'woo-multidomain' ) ?></option>
                                                    <?php
                                                    
                                                        $sites  =   $this->woomd_network->get_domains( );
                                                        foreach($sites['items']  as  $site)
                                                            {
                                                                $domain_details =   $this->woomd_network->get_domain( $site['id'] );
                                                                
                                                                ?><option value="<?php echo $domain_details->id ?>" <?php selected( $domain_details->id, $options['cart_checkout_location']); ?>><?php echo $domain_details->blogname ?></option><?php
                                                            }
                                                    
                                                    ?>
                                                </select>
                                            </th>
                                            <td>
                                                <label><?php _e( "Cart Checkout location", 'woo-multidomain' ) ?></label>
                                                <p class="help"><?php _e( "The option is being used when Checkout Type being set as Single Checkout. <br />When checkout a user will be redirected to a specific site to complete the order or he can proceed to any site. ", 'woo-multidomain' ) ?></p>
                                            </td>
                                        </tr>
                               
                                    </tbody>
                                </table>
                                
                                
                                <h4>Content</h4>
                                <table class="form-table">
                                    <tbody>
                                                                                
                                        <tr valign="top">
                                            <th scope="row">
                                                <input id="hided_products_not_showing_on_domain" name="hided_products_not_showing_on_domain" type="checkbox" value="yes" <?php if ( $options['hided_products_not_showing_on_domain'] == 'yes' ) { ?>checked="checked"<?php } ?> />
                                            </th>
                                            <td>
                                                <label for="hided_products_not_showing_on_domain"><?php _e( "Hided products not showing on Domain", 'woo-multidomain' ) ?></label>
                                                <p class="help"><?php _e( "When hiding a product through the Dashboard edit area, this particular product will not appear on the Domain Dashboard, Shop or search.", 'woo-multidomain' ) ?></p>
                                            </td>
                                        </tr>
                                        
                                        <tr valign="top">
                                            <th scope="row">
                                                <input id="allow_product_different_content" name="allow_product_different_content" type="checkbox" value="yes" <?php if ( $options['allow_product_different_content'] == 'yes' ) { ?>checked="checked"<?php } ?> />
                                            </th>
                                            <td>
                                                <label for="allow_product_different_content"><?php _e( "Allow product different Content", 'woo-multidomain' ) ?></label>
                                                <p class="help"><?php _e( "When using the option, each of the product content can be customized and use its texts and descriptions.", 'woo-multidomain' ) ?></p>
                                            </td>
                                        </tr>
                                        
                                        <tr valign="top">
                                            <th scope="row">
                                                <input id="each_domain_posts_pages_content" name="each_domain_posts_pages_content" type="checkbox" value="yes" <?php if ( $options['each_domain_posts_pages_content'] == 'yes' ) { ?>checked="checked"<?php } ?> />
                                            </th>
                                            <td>
                                                <label for="each_domain_posts_pages_content"><?php _e( "Each Domain Content", 'woo-multidomain' ) ?></label>
                                                <p class="help"><?php _e( "The option provides the functionality for each of the domains to use its own Posts and Pages content for better integration and unicity on the market. The other domain's posts are pages become accessible unless using the matching domain.", 'woo-multidomain' ) ?></p>
                                                <p class="help"><?php _e( "This is recommended to be active for SEO purposes, as duplicated content can hurt in ranking.", 'woo-multidomain' ) ?></p>
                                            </td>
                                        </tr>
                                        
                                        <tr valign="top">
                                            <th scope="row">
                                                <input id="load_all_dependencies_through_local_domain" name="load_all_dependencies_through_local_domain" type="checkbox" value="yes" <?php if ( $options['load_all_dependencies_through_local_domain'] == 'yes' ) { ?>checked="checked"<?php } ?> />
                                            </th>
                                            <td>
                                                <label for="load_all_dependencies_through_local_domain"><?php _e( "Load all dependencies through Local Domain", 'woo-multidomain' ) ?></label>
                                                <p class="help"><?php _e( "When loading the assets on the front side, they may belong to other domains ( e.g. images ). The option, ensure all such dependencies are loaded through the local Domain URL.", 'woo-multidomain' ) ?></p>
                                                <p class="help"><?php _e( "This is recommended to be active.", 'woo-multidomain' ) ?></p>
                                            </td>
                                        </tr>
                               
                                    </tbody>
                                </table>
                                
                                
                                <?php do_action('woomd/options/options_html');  ?>
                                               
                                <p class="submit">
                                    <input type="submit" name="Submit" class="button-primary" value="<?php _e('Save Settings', 'woo-multidomain') ?>">
                                </p>
                            
                                <?php wp_nonce_field('woomd_form_submit','woomd_form_nonce'); ?>
                                <input type="hidden" name="woomd_form_submit" value="true" />
                                
                            </form>
                            
                            <?php } ?>
                        </div>                                  
                    <?php

                }

        }

?>