<?php

    if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
    
    class Woo_MultiDomain_interface
        {
            
            var $main_menu_slug =   'woo-multidomain';
            var $functions;
            
            var $section    =   '';
            var $tab        =   '';
                   
            function __construct()
                {
                    global $woo_multidomain;
                    
                    $this->functions        =   $woo_multidomain->functions;
                    
                    include_once( WOOMULTID_PATH . '/includes/admin/all-domains.php' );
                    include_once( WOOMULTID_PATH . '/includes/admin/add-domains.php' );
                    include_once( WOOMULTID_PATH . '/includes/admin/general-settings.php' );
                    
                    add_action( 'admin_menu',               array( $this,   'admin_menus' ) ); 
                    add_filter( 'set-screen-option',        array( $this,   'set_screen_option' ), 10, 3);   
                    
                    $this->section  =   isset($_GET['section']) ?   $_GET['section']    :   ''; 
                    $this->tab      =   ! empty ($this->section ) && isset($_GET['tab'])     ?   $_GET['tab']    :   'domain-info';
                }

            
            
            /**
            * Add the menus
            * 
            */
            function admin_menus()
                {
                        
                    add_menu_page( 'WooMultiDomain', 'WooMultiDomain', 'manage_options', $this->main_menu_slug, array( $this, 'menus_all_domains'), '', 3 );
                    $hookID   =     add_submenu_page( $this->main_menu_slug, 'WooMultiDomain', "All Domains", 'manage_options', $this->main_menu_slug, array( $this, 'menus_all_domains'));
                    
                    add_action('admin_print_styles-' . $hookID ,    array($this, 'admin_print_styles'));
                    add_action('admin_print_scripts-' . $hookID ,   array($this, 'admin_print_scripts'));
                    add_action( 'load-' . $hookID,                  array($this, 'load'));
                        
                    add_action('admin_head-' . $hookID ,            array($this, 'admin_head'));
                    
                    $hookID   =     add_submenu_page( $this->main_menu_slug, 'WooMultiDomain', "Add Domain", 'manage_options', 'woo-multidomain-add', array( $this, 'menus_add_domain'));
                    
                    add_action('admin_print_styles-' . $hookID ,    array($this, 'admin_print_styles'));
                    add_action('admin_print_scripts-' . $hookID ,   array($this, 'admin_print_scripts'));
                    //add_action( 'load-' . $hookID,                  array( 'WooMD_All_Domains', 'load'));
                    add_action('admin_head-' . $hookID ,            array($this, 'admin_head'));
                    
                    $hookID   =     add_submenu_page( $this->main_menu_slug, 'WooMultiDomain', "Settings", 'manage_options', 'woo-multidomain-settings', array( $this, 'menus_settings'));
                    add_action('admin_head-' . $hookID ,            array('WooMD_Settings', 'admin_print_styles'));
                    add_action('admin_head-' . $hookID ,            array('WooMD_Settings', 'admin_print_scripts'));
                }
                
            
            function admin_notices()
                {
                    $messages = array();
                    if(isset($_GET['settings_saved']) && $_GET['settings_saved'] == 'true')
                        $messages[] =   'Sort settings saved.';    
                        
                    if(isset($_GET['sort_deleted']) && $_GET['sort_deleted'] == 'true')
                        $messages[] =   'Sort deleted.';
                    
                    if(count($messages) > 0)
                        {
                            echo "<div id='notice' class='updated fade'><p>". implode("</p><p>", $messages )  ."</p></div>";
                        }
                }
            
            function admin_print_styles()
                {
      
                }
            
                   
            function admin_print_scripts()
                {
      
                }
                
            
            /**
            * Save the per-screen option
            * 
            * @param mixed $status
            * @param mixed $option
            * @param mixed $value
            */
            function set_screen_option( $status, $option, $value )
                {
                    list($found , $status) =   WooMD_All_Domains::set_screen_option( $status, $option, $value );
                    if ( $found ) return $status;
                    
                    
                    return $status;
                
                }  
                
            
            function load()
                {
                    
                    if (  empty ( $this->section )  ||  empty ( $this->tab ))
                        WooMD_All_Domains::load();
                    
                    
                }
                  
                
            function admin_head()
                {
                    
                    $current_screen =   get_current_screen();       
                    switch ( $current_screen->id )
                        {
                            case 'toplevel_page_woo-multidomain'    :
                                                                        if (  ! empty ( $this->section ) )
                                                                            {
                                                                                
                                                                                if ( $this->tab    ==  'domain-info' )
                                                                                    {
                                                                                        include_once( WOOMULTID_PATH . '/includes/admin/domain-info.php' );
                                                                                        WooMD_Domain_Edit_Info::set_screen_data();
                                                                                    }
                                                                                
                                                                                
                                                                                if ( $this->tab    ==  'domain-themes' )
                                                                                    {
                                                                                        include_once( WOOMULTID_PATH . '/includes/admin/domain-themes.php' );
                                                                                        WooMD_Domain_Edit_Themes::set_screen_data();
                                                                                    }
                                                                                    
                                                                                if ( $this->tab    ==  'domain-settings' )
                                                                                    {
                                                                                        include_once( WOOMULTID_PATH . '/includes/admin/domain-info.php' );
                                                                                        WooMD_Domain_Edit_Info::set_screen_data();
                                                                                    }
                                                                                    
                                                                            }
                                                                            else
                                                                            WooMD_All_Domains::set_screen_data();
                                                                            
                                                                        break;
     
                            
                        }
                    
                }
                
            
            function menus_all_domains()
                {
                    $instance   =   new WooMD_All_Domains();
                    $instance->init();
                }
                
                
            function menus_add_domain()
                {
                    $instance   =   new WooMD_Add_Domain();
                    $instance->init();
                }
                
            
            function menus_settings()
                {
                    $instance   =   new WooMD_Settings();
                    $instance->init();
                }
                
                
                
                
            
        /**
        * Outputs the HTML for a network's "Edit Site" tabular interface.
        *
        * @since 4.6.0
        *
        * @param $args {
        *     Optional. Array or string of Query parameters. Default empty array.
        *
        *     @type int    $blog_id  The site ID. Default is the current site.
        *     @type array  $links    The tabs to include with (label|url|cap) keys.
        *     @type string $selected The ID of the selected link.
        * }
        */
        function network_edit_domain_nav( $args = array() ) 
            {

                $links = apply_filters(
                    'network_edit_site_nav_links',
                    array(
                        'domain-info'     => array(
                            'label' => __( 'Info' ),
                            'url'   => 'admin.php?page=woo-multidomain&section=domain-edit',
                            'cap'   => 'manage_sites',
                        ),
                        'domain-themes'   => array(
                            'label' => __( 'Themes' ),
                            'url'   => 'admin.php?page=woo-multidomain&section=domain-edit',
                            'cap'   => 'manage_sites',
                        ),
                        'domain-settings' => array(
                            'label' => __( 'Settings' ),
                            'url'   => 'admin.php?page=woo-multidomain&section=domain-edit',
                            'cap'   => 'manage_sites',
                        ),
                    )
                );

                // Parse arguments
                $r = wp_parse_args(
                    $args,
                    array(
                        'blog_id'  => isset( $_GET['blog_id'] ) ? (int) $_GET['blog_id'] : 0,
                        'links'    => $links,
                        'selected' => 'site-info',
                    )
                );

                // Setup the links array
                $screen_links = array();

                // Loop through tabs
                foreach ( $r['links'] as $link_id => $link ) {
          
                    // Link classes
                    $classes = array( 'nav-tab' );

                    // Selected is set by the parent OR assumed by the $pagenow global
                    if ( $r['selected'] === $link_id || $link['url'] === $GLOBALS['pagenow'] ) {
                        $classes[] = 'nav-tab-active';
                    }

                    // Escape each class
                    $esc_classes = implode( ' ', $classes );

                    // Get the URL for this link
                    $url = add_query_arg( array( 'id' => $r['blog_id'], 'tab'   =>  $link_id ), admin_url( $link['url'] ) );

                    // Add link to nav links
                    $screen_links[ $link_id ] = '<a href="' . esc_url( $url ) . '" id="' . esc_attr( $link_id ) . '" class="' . $esc_classes . '">' . esc_html( $link['label'] ) . '</a>';
                }

                // All done!
                echo '<h2 class="nav-tab-wrapper wp-clearfix">';
                echo implode( '', $screen_links );
                echo '</h2>';
            }
                
                
        } 


?>