<?php
    
    class Woo_MultiDomain_product_interface 
        {
            
            var $functions;
            var $woomd_network;

            /**
             * __construct function.
             *
             * @access public
             * @return void
             */
            public function __construct() 
                {
                    
                    global $woo_multidomain;
                        
                    $this->functions        =   $woo_multidomain->functions;
                    $this->woomd_network    =   $woo_multidomain->functions->network;                                                                     

                    //simple
                    add_action( 'woocommerce_product_options_pricing',                array ( $this, 'woocommerce_product_options_pricing'));
                    add_action( 'woocommerce_product_options_general_product_data',   array ( $this, 'woocommerce_product_options_general_product_data'));
                                        
                    add_filter( 'woocommerce_process_product_meta',         array( $this, 'product_save_data' ) );
                    
                    //enqueue css & js for product post type
                    add_action( 'admin_enqueue_scripts',                    array($this, 'add_admin_product_scripts'), 10, 1);

                }
                
            function add_admin_product_scripts($hook)
                {
                   
                    $screen = get_current_screen();

                    if(!is_object($screen) || $screen->id != 'product')
                        return;
                    
                    $myFile = WOOMULTID_URL . '/assets/css/admin-product.css';
                    wp_register_style('admin-product.css', $myFile);
                    wp_enqueue_style( 'admin-product.css');
                    
                    $myJavascriptFile = WOOMULTID_URL . '/assets/js/admin-product.js';
                    wp_register_script('admin-product.js', $myJavascriptFile);
                    wp_enqueue_script( 'admin-product.js');        
                }
     
     
            
            /**
            * Allow diffrent price to be set for each domain
            * 
            */
            static public function woocommerce_product_options_pricing()
                {
                    global $product_object;
                                   
                    ?>
                        <div class="options_group">
                            <div class="form-field woomd_prices">
                                <label><?php esc_html_e( 'Sale price', 'woo-multidomain' ); ?> (<?php echo get_woocommerce_currency_symbol(); ?>)</label>
                                <table class="widefat">
                                    <thead>
                                        <tr>
                                            <th class="sort">&nbsp;</th>
                                            <th><?php esc_html_e( 'Domain', 'woo-multidomain' ); ?> <?php echo wc_help_tip( __( 'This is the domain for which a custom price can be set.', 'woocommerce' ) ); ?></th>
                                            <th><?php esc_html_e( 'Custom Price', 'woocommerce' ); ?> <?php echo wc_help_tip( __( 'This is the custom price which will be used on domain for current product. If left empty, default price will be used instead.', 'woocommerce' ) ); ?></th>
                                    
                                        </tr>
                                    </thead>
                                    <tbody>

                                    
                                    <tbody class="ui-sortable">
                                        
                                        <?php
                                            
                                            global $woo_multidomain, $blog_id;
                                            
                                            $args           =   array ( );
                                            $data           =   $woo_multidomain->functions->network->get_domains( $args );
                                            $all_domains    =   $data['items'];
                                            
                                            foreach ( $all_domains as   $domain )
                                                {
                                                    
                                                    if  ( $blog_id  ==  $domain['id'] )
                                                        continue;
                                                    
                                                    $woo_multidomain->functions->network->switch_to_domain( $domain['id'] );
                                                    
                                                    $_domain_product_object =   wc_get_product( $product_object->get_ID() );
                                                    
                                                    ?>
                                                    
                                                    <tr>
                                                        <td class="tag"></td>
                                                        <td class="domain_info">
                                                            <p><?php echo get_option('blogname'); ?><br />
                                                            <i><?php echo  $domain['domain'] ?></i></p>
                                                        </td>
                                                        <td class="custom_price">
                                                            <table>
                                                                <tr class="title">
                                                                    <td>Regular Price</td>
                                                                    <td><input class="input_text" name="_woomd_regular_price[<?php echo $domain['id'] ?>]" value="<?php echo $_domain_product_object->get_regular_price( 'edit' ) ?>" type="text" /></td>
                                                                </tr>
                                                                <tr>
                                                                    <td>Sale Price</td>
                                                                    <td><input class="input_text" name="_woomd_sale_price[<?php echo $domain['id'] ?>]"    value="<?php echo $_domain_product_object->get_sale_price( 'edit' ) ?>" type="text" /></td>
                                                                </tr>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                    <?php 
                                                    
                                                    $woo_multidomain->functions->network->restore_current_domain();
                                                    
                                                } ?>
                                      
                                    </tbody>
                                </table>
                            </div>
                           
                           
                        </div>
                    
                    
                    <?php 
                    
                }
                
            
            /**
            * Allow diffrent price to be set for each domain
            * 
            */
            static public function woocommerce_product_variation_options_pricing( $loop, $variation_data, $variation )
                {
                    
                    $product_object =   wc_get_product( $variation->ID );
                       
                    ?>
                        <div class="options_group form-row form-row-full">
                            <div class="form-field woomd_prices">
                                <label><?php esc_html_e( 'Sale price', 'woo-multidomain' ); ?> (<?php echo get_woocommerce_currency_symbol(); ?>)</label>
                                <table class="widefat">
                                    <thead>
                                        <tr>
                                            <th class="sort">&nbsp;</th>
                                            <th><?php esc_html_e( 'Domain', 'woo-multidomain' ); ?> <?php echo wc_help_tip( __( 'This is the domain for which a custom price can be set.', 'woocommerce' ) ); ?></th>
                                            <th><?php esc_html_e( 'Custom Price', 'woocommerce' ); ?> <?php echo wc_help_tip( __( 'This is the custom price which will be used on domain for current product. If left empty, default price will be used instead.', 'woocommerce' ) ); ?></th>
                                    
                                        </tr>
                                    </thead>
                                    <tbody>

                                    
                                    <tbody class="ui-sortable">
                                        
                                        <?php
                                            
                                            global $woo_multidomain, $blog_id;
                                            
                                            $args           =   array ( );
                                            $data           =   $woo_multidomain->functions->network->get_domains( $args );
                                            $all_domains    =   $data['items'];
                                            
                                            foreach ( $all_domains as   $domain )
                                                {
                                                    
                                                    if  ( $blog_id  ==  $domain['id'] )
                                                        continue;
                                                    
                                                    $woo_multidomain->functions->network->switch_to_domain( $domain['id'] );
                                                    
                                                    $_domain_product_object =   wc_get_product( $product_object->get_ID() );
                                                    
                                                    ?>
                                                    
                                                    <tr>
                                                        <td class="tag"></td>
                                                        <td class="domain_info">
                                                            <p><?php echo get_option('blogname'); ?><br />
                                                            <i><?php echo  $domain['domain'] ?></i></p>
                                                        </td>
                                                        <td class="custom_price">
                                                            <table>
                                                                <tr class="title">
                                                                    <td>Regular Price</td>
                                                                    <td><input class="input_text" name="_woomd_regular_price[<?php echo $loop ?>][<?php echo $domain['id'] ?>]" value="<?php echo $_domain_product_object->get_regular_price( 'edit' ) ?>" type="text" /></td>
                                                                </tr>
                                                                <tr>
                                                                    <td>Sale Price</td>
                                                                    <td><input class="input_text" name="_woomd_sale_price[<?php echo $loop ?>][<?php echo $domain['id'] ?>]"    value="<?php echo $_domain_product_object->get_sale_price( 'edit' ) ?>" type="text" /></td>
                                                                </tr>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                    <?php 
                                                    
                                                    $woo_multidomain->functions->network->restore_current_domain();
                                                    
                                                } ?>
                                      
                                    </tbody>
                                </table>
                            </div>
                           
                           
                        </div>
                    
                    
                    <?php 
                    
                }
                
                
                
                
            /**
            * Control visibility of a product on specific domains
            *     
            */
            function woocommerce_product_options_general_product_data()
                {
                    
                    ?>
                        
                        <div class="options_group">
                            <div class="form-field woomd_prices">
                                <label><?php esc_html_e( 'Product Visibility', 'woo-multidomain' ); ?></label>
                                <table class="widefat">
                                    <thead>
                                        <tr>
                                            <th class="sort">&nbsp;</th>
                                            <th><?php esc_html_e( 'Domain', 'woo-multidomain' ); ?> <?php echo wc_help_tip( __( 'This is the domain for which prduct visibility can be set.', 'woocommerce' ) ); ?></th>
                                            <th><?php esc_html_e( 'Visibility', 'woocommerce' ); ?> <?php echo wc_help_tip( __( 'If selected, product is visible for domain.', 'woocommerce' ) ); ?></th>
                                    
                                        </tr>
                                    </thead>
                                    <tbody>

                                    
                                    <tbody class="ui-sortable">
                                        
                                        <?php
                                            
                                            global $wpdb, $blog_id, $product_object;
                                            
                                            $args           =   array ( );
                                            $data           =   $this->woomd_network->get_domains( $args );
                                            $all_domains    =   $data['items'];
                                            
                                            foreach ( $all_domains as   $domain )
                                                {
                                                    
                                                    $this->woomd_network->switch_to_domain( $domain['id'] );
                                                    
                                                    $_domain_product_object =   wc_get_product( $product_object->get_ID() );
                                                    
                                                    $meta_key    =   '';
                                                    if ( $blog_id > 1 )
                                                        $meta_key    =   '_' .   $wpdb->base_prefix  .   $blog_id;
                                                    $meta_key   .=  '_womd_visibility';
                                                    
                                                    $visibility_hide    =   get_post_meta( $product_object->get_ID(), $meta_key, TRUE );
                                                    
                                                    $visibility =   TRUE;
                                                    if ( ! empty ( $visibility_hide ))
                                                        $visibility =   FALSE;
                                                        
                                                    if  ( $domain['id'] == "1" )
                                                        $visibility =   TRUE;
                                                    
                                                    ?>
                                                    
                                                    <tr>
                                                        <td class="tag"></td>
                                                        <td class="domain_info">
                                                            <p><?php echo get_option('blogname'); ?><br />
                                                            <i><?php echo  $domain['domain'] ?></i></p>
                                                        </td>
                                                        <td class="visibility">
                                                            <input <?php  if  ( $domain['id']   ==   '1' ) {  ?>disabled="disabled"<?php }    ?> class="checkbox" style="" name="_woomd_visibility[<?php echo $domain['id'] ?>]" value="yes" <?php checked( $visibility, TRUE ); ?>  type="checkbox" />
                                                        </td>
                                                    </tr>
                                                    <?php 
                                                    
                                                    $this->woomd_network->restore_current_domain();
                                                    
                                                } ?>
                                      
                                    </tbody>
                                </table>
                            </div>
                           
                           
                        </div>
                    
                    
                    <?php    
                    
                    
                }
     
         
            /**
             * Saves the data for the product
             */
            public function product_save_data( $product_id ) 
                {
                    global $wpdb, $blog_id;
                    
                    $product    =   wc_get_product( $product_id );
                    if ( $product->get_type() == 'simple'   ||  $product->get_type() == 'external' )
                        {
                            //Prices
                            $_woomd_regular_price   =   $_POST['_woomd_regular_price'];
                            $_woomd_sale_price      =   $_POST['_woomd_sale_price'];
                            foreach  ( $_woomd_regular_price    as  $domain_id  =>  $value)
                                {
                                    if ( empty ( $value ) )
                                        continue;
                                    
                                    $meta_key_name    =   '_regular_price';
                                    if ( $domain_id > 1 )
                                        $meta_key_name    =   '_' .   $wpdb->base_prefix  .   $domain_id    .   $meta_key_name;
                                        
                                    update_post_meta( $product_id, $meta_key_name, $_woomd_regular_price[ $domain_id ]);
                                    
                                    $meta_key_name    =   '_sale_price';
                                    if ( $domain_id > 1 )
                                        $meta_key_name    =   '_' .   $wpdb->base_prefix  .   $domain_id    .   $meta_key_name;
                                        
                                    update_post_meta( $product_id, $meta_key_name, $_woomd_sale_price[ $domain_id ]);
                                    
                                    $price  =   $_woomd_regular_price[ $domain_id ];
                                    if ( ! empty ( $_woomd_sale_price[ $domain_id ] ) &&    $_woomd_sale_price[ $domain_id ]   >   $_woomd_regular_price[ $domain_id ] )
                                        $price  =   $_woomd_sale_price[ $domain_id ];
                                        
                                    $meta_key_name    =   '_price';
                                    if ( $domain_id > 1 )
                                        $meta_key_name    =   '_' .   $wpdb->base_prefix  .   $domain_id    .   $meta_key_name;
                                        
                                    update_post_meta( $product_id, $meta_key_name, $price);
                                    
                                }
                        }
                        
                        
                    //Visibility
                    $woomd_visibility   =   $_POST['_woomd_visibility'];
                    
                    $args           =   array ( 
                                                'fields'    =>  'ids',
                                                'exclude'   =>  array('1')
                                                 );
                    $data           =   $this->woomd_network->get_domains( $args );
                    $all_domains    =   $data['items'];
                    
                    $_process_ids   =   array( $product_id );
                    
                    /*
                    if ( $product->get_type()   ==  'simple' )
                            $_process_ids   =   array( $product_id );
                        else
                        {
                            //retrieve all variations
                            $_process_ids    =   $product->get_children();      
                        }
                    */
                    
                    foreach  ( $_process_ids  as $_product_id )
                        {
                            //remove all visibility fields
                            $mysq_query =   $wpdb->prepare( "DELETE FROM " . $wpdb->postmeta    ."
                                                                WHERE post_id   =   %d  AND meta_key    LIKE    '%_womd_visibility'" ,  $_product_id );
                            $results    =   $wpdb->get_results( $mysq_query );
                            
                            //add non-visible items
                            $meta_key    =   '';
                            foreach ( $all_domains  as  $domain )
                                {
                                    if ( !isset( $woomd_visibility[$domain['id']] )    ||  empty ( $woomd_visibility[$domain['id']] ))
                                        {
                                            if ( $domain['id'] > 1 )
                                                $meta_key    =   '_' .   $wpdb->base_prefix  .   $domain['id'];
                                            $meta_key   .=  '_womd_visibility';
                                            
                                            add_post_meta( $_product_id, $meta_key, 'hide' );
                                        }
                                }
                        }
              
                }
                
                
            function woocommerce_save_product_variation( $variation_id, $i )
                {
                    
                    global $wpdb, $blog_id;
                              
                    //Prices
                    $_woomd_regular_price   =   $_POST['_woomd_regular_price'][$i];
                    $_woomd_sale_price      =   $_POST['_woomd_sale_price'][$i];
                    foreach  ( $_woomd_regular_price    as  $domain_id  =>  $value)
                        {
                            if ( empty ( $value ) )
                                continue;
                            
                            $meta_key_name    =   '_regular_price';
                            if ( $domain_id > 1 )
                                $meta_key_name    =   '_' .   $wpdb->base_prefix  .   $domain_id    .   $meta_key_name;
                                
                            update_post_meta( $variation_id, $meta_key_name, $_woomd_regular_price[ $domain_id ]);
                            
                            $meta_key_name    =   '_sale_price';
                            if ( $domain_id > 1 )
                                $meta_key_name    =   '_' .   $wpdb->base_prefix  .   $domain_id    .   $meta_key_name;
                                
                            update_post_meta( $variation_id, $meta_key_name, $_woomd_sale_price[ $domain_id ]);
                            
                            $price  =   $_woomd_regular_price[ $domain_id ];
                            if ( ! empty ( $_woomd_sale_price[ $domain_id ] ) &&    $_woomd_sale_price[ $domain_id ]   >   $_woomd_regular_price[ $domain_id ] )
                                $price  =   $_woomd_sale_price[ $domain_id ];
                                
                            $meta_key_name    =   '_price';
                            if ( $domain_id > 1 )
                                $meta_key_name    =   '_' .   $wpdb->base_prefix  .   $domain_id    .   $meta_key_name;
                                
                            update_post_meta( $variation_id, $meta_key_name, $price);
                            
                        }    
                        
                }
          
            
        }
        
?>