<?php

    
    /**
    * Network Class
    */
    class Woo_MultiDomain_Network 
        {
            
            public function __construct()
                {
                    //ensure there is a default domain entry in the table
                    if ( ! self::is_initialised() )
                        self::do_initialise();                    
                }
            
            
            /**
            * Check if at least one primary domain has been set-up
            * 
            */
            public static function is_initialised()
                {
                    
                    global $wpdb;
                    
                    $mysql_query    =    "SELECT * FROM "    .   $wpdb->prefix  ."woocommerce_woomd_domains
                                                                WHERE type = 'primary'";
                    $domain_data         =   $wpdb->get_row( $mysql_query );
                    
                    return ! empty ( $domain_data );
                       
                    
                }
                
            
            /**
            * Initialize the default ( first ) domain
            * 
            */
            public static function do_initialise()
                {
                   
                    $domain  =   self::get_current_domain();
                    $path    =   '/';
                    
                    global $wpdb;

                    $result = $wpdb->insert( $wpdb->prefix . "woocommerce_woomd_domains", array( 'domain' => esc_sql ( $domain ), 'path' => $path, 'registered' => current_time('mysql'), 'type'  =>  'primary'   ) );
                    if ( ! $result )
                        return new WP_Error('mysql_insert_blog', __('Could not create site.'));

                    $blog_id = $wpdb->insert_id;
                    
                    return $blog_id;    
                    
                }
                
            
            /**
            * Check if current domain was previouslly set-up
            *     
            */
            public static function is_current_domain_setup()
                {
                    
                    $domain  =   self::get_current_domain();
                    
                    $domain_data    =   self::get_domain_records( $domain );    
                    if ( empty ( $domain_data ) )
                        return FALSE;
                        
                    return TRUE;
                    
                }
            
                
            public static function get_current_domain_id() 
                {
                    global $blog_id;
                    return absint($blog_id);
                }
            
            function switch_to_domain( $new_blog )
                {
                    global $wpdb;

                    $blog_id = $this->get_current_domain_id();
                    if ( empty( $new_blog ) ) {
                        $new_blog = $blog_id;
                    }

                    $GLOBALS['_wp_switched_stack'][] = $blog_id;

                    /*
                     * If we're switching to the same blog id that we're on,
                     * set the right vars, do the associated actions, but skip
                     * the extra unnecessary work
                     */
                    if ( $new_blog == $blog_id ) 
                        {
                            do_action( 'woomd/switch_domain', $new_blog, $new_blog );
                            $GLOBALS['switched'] = true;
                            return true;
                        }

                    $this->wpdb_set_blog_id( $new_blog );
                    $prev_blog_id = $blog_id;
                    $GLOBALS['blog_id'] = $new_blog;
                    
                    if ( function_exists( 'wp_cache_switch_to_blog' ) ) {
                        wp_cache_switch_to_blog( $new_blog);
                    } else {
                        global $wp_object_cache;

                        if ( is_object( $wp_object_cache ) && isset( $wp_object_cache->global_groups ) ) {
                            $global_groups = $wp_object_cache->global_groups;
                        } else {
                            $global_groups = false;
                        }

                        wp_cache_init();

                        if ( function_exists( 'wp_cache_add_global_groups' ) ) {
                            if ( is_array( $global_groups ) ) {
                                wp_cache_add_global_groups( $global_groups );
                            } else {
                                wp_cache_add_global_groups( array( 'users', 'userlogins', 'usermeta', 'user_meta', 'useremail', 'userslugs', 'site-transient', 'site-options', 'blog-lookup', 'blog-details', 'rss', 'global-posts', 'blog-id-cache', 'networks', 'sites', 'site-details' ) );
                            }
                            wp_cache_add_non_persistent_groups( array( 'counts', 'plugins' ) );
                        }
                    }
                                              
                    /** This filter is documented in wp-includes/ms-blogs.php */
                    do_action( 'woomd/switch_domain', $new_blog, $prev_blog_id );
                    $GLOBALS['switched'] = true;

                    return true;   
                    
                }
                
                
                
            function restore_current_domain()
                {
                    global $wpdb;

                    if ( empty( $GLOBALS['_wp_switched_stack'] ) ) {
                        return false;
                    }

                    $blog = array_pop( $GLOBALS['_wp_switched_stack'] );
                    $blog_id = $this->get_current_domain_id();

                    if ( $blog_id == $blog ) {
                        /** This filter is documented in wp-includes/ms-blogs.php */
                        do_action( 'woomd/switch_blog', $blog, $blog );
                        // If we still have items in the switched stack, consider ourselves still 'switched'
                        $GLOBALS['switched'] = ! empty( $GLOBALS['_wp_switched_stack'] );
                        return true;
                    }

                    $this->wpdb_set_blog_id( $blog );
                    $prev_blog_id = $blog_id;
                    $GLOBALS['blog_id'] = $blog;
                    
                    if ( function_exists( 'wp_cache_switch_to_blog' ) ) {
                        wp_cache_switch_to_blog( $blog );
                    } else {
                        global $wp_object_cache;

                        if ( is_object( $wp_object_cache ) && isset( $wp_object_cache->global_groups ) ) {
                            $global_groups = $wp_object_cache->global_groups;
                        } else {
                            $global_groups = false;
                        }

                        wp_cache_init();

                        if ( function_exists( 'wp_cache_add_global_groups' ) ) {
                            if ( is_array( $global_groups ) ) {
                                wp_cache_add_global_groups( $global_groups );
                            } else {
                                wp_cache_add_global_groups( array( 'users', 'userlogins', 'usermeta', 'user_meta', 'useremail', 'userslugs', 'site-transient', 'site-options', 'blog-lookup', 'blog-details', 'rss', 'global-posts', 'blog-id-cache', 'networks', 'sites', 'site-details' ) );
                            }
                            wp_cache_add_non_persistent_groups( array( 'counts', 'plugins' ) );
                        }
                    }
                        
                    /** This filter is documented in wp-includes/ms-blogs.php */
                    do_action( 'woomd/switch_blog', $blog, $prev_blog_id );

                    // If we still have items in the switched stack, consider ourselves still 'switched'
                    $GLOBALS['switched'] = ! empty( $GLOBALS['_wp_switched_stack'] );

                    return true;    
                    
                    
                }
            
            
            /**
            * Re-load the options set list for current domain
            * 
            */
            public static function reload_alloptions()
                {
                    global $wpdb;
                    
                    $suppress = $wpdb->suppress_errors();
                    if ( ! $alloptions_db = $wpdb->get_results( "SELECT option_name, option_value FROM $wpdb->options WHERE autoload = 'yes'" ) ) 
                        {
                            $alloptions_db = $wpdb->get_results( "SELECT option_name, option_value FROM $wpdb->options" );
                        }
                    $wpdb->suppress_errors( $suppress );

                    $alloptions = array();
                    foreach ( (array) $alloptions_db as $o ) 
                        {
                            $alloptions[ $o->option_name ] = $o->option_value;
                        }

                    if ( ! wp_installing() || ! is_multisite() ) 
                        {
                            $alloptions = apply_filters( 'pre_cache_alloptions', $alloptions );
                            wp_cache_delete( 'alloptions', 'options' );
                            wp_cache_add( 'alloptions', $alloptions, 'options' );
                        }
                        
                    return apply_filters( 'alloptions', $alloptions );   
                    
                }
            
            
            public function wpdb_set_blog_id( $domain_id ) 
                {
                    global $wpdb;
                    
                    $old_blog_id  = $wpdb->blogid;
                    $wpdb->blogid = $domain_id;

                    $options_table = $this->get_blog_prefix()   .   'options';

                    $wpdb->options  =   $options_table;

                    return $old_blog_id;
                }
                
                
            public function wpdb_get_blog_prefix( $domain_id ) 
                {
                    global $wpdb;
                    
                    if  ( $domain_id    <   2 )
                        return $wpdb->base_prefix;

                    return $wpdb->base_prefix . $domain_id . "_";
                }

            /**
             * Gets blog prefix.
             *
             * @since 3.0.0
             * @param int $blog_id Optional.
             * @return string Blog prefix.
             */
            public function get_blog_prefix( $blog_id = null ) 
                {
                    global $wpdb;
                    
                    if ( null === $blog_id ) 
                        {
                            $blog_id = $wpdb->blogid;
                        }
                    $blog_id = (int) $blog_id;
                    if (  0 == $blog_id || 1 == $blog_id ) 
                        {
                            return $wpdb->base_prefix;
                        } 
                    else 
                        {
                            return $wpdb->base_prefix . $blog_id . '_';
                        }
                }
            
            
            /**
            * Return domain data by id
            * 
            * @param mixed $domain_id
            * @return mixed
            */
            function get_domain( $domain_id )
                {
                    
                    //get the domain data by domain
                    $args = array(
                        'id'     => $domain_id,
                    );
                    $result = $this->get_domains( $args );
                    $domain_data = array_shift( $result['items'] );
                    
                    $this->switch_to_domain( $domain_id );
                    
                    $domain_data['blogname']   = get_option( 'blogname' );
                    $domain_data['blogdescription']   = get_option( 'blogdescription' );
                    $domain_data['siteurl']    = get_option( 'siteurl' );
                    $domain_data['home']       = get_option( 'home' );
                    
                    $this->restore_current_domain();
                    
                    return (object)$domain_data; 
                    
                }
                
            
            /**
            * Return available domains
            * 
            * @param mixed $args
            */
            public function get_domains( $args   =   array() )
                {
                    
                    $defaults = array( 
                                        'fields'        =>  '',
                                        
                                        'search'        =>  '',
                                        
                                        'id'            =>  '',
                                        'domain'        =>  '',
                                        'path'          =>  '',
                                        
                                        'number'        =>  '',
                                        'offset'        =>  '0',
                                        
                                        'exclude'       =>  array()
                                        );
                    $args = wp_parse_args( $args, $defaults );
                    
                    
                    global $wpdb;
                    
                    switch ( $args['fields'] )
                        {
                            case 'ids'  :
                                            $fields =   'id';
                                            break;    
                            
                            default : 
                                        if  ( empty ( $args['fields'] ) )
                                            $fields =   ' * ';
                                            else
                                            $fields =   $args['fields'];
                                            
                                        break;   
                        }
                        
                    
                    
                    $mysql_query    =    "SELECT SQL_CALC_FOUND_ROWS " . $fields . " FROM " . $wpdb->prefix . "woocommerce_woomd_domains";
                    
                    //WHERE
                    $mysql_query    .=  "   WHERE 1 = 1 ";
                    
                    //Search 
                    if ( ! empty ($args['search']) )
                        {
                            $mysql_query    .=  $wpdb->prepare( " AND domain LIKE %s", '%' . $args['search'] . '%');
                        }
                    
                    if ( ! empty ($args['id'])  ||  ! empty ($args['domain'])  ||  ! empty ( $args['path'] ) )
                        {
                            
                            if ( ! empty ($args['id']) )
                                $mysql_query    .=  $wpdb->prepare(" AND id = %d", $args['id']) ;
                            if ( ! empty ($args['domain']) )
                                $mysql_query    .=  $wpdb->prepare(" AND domain = %s", $args['domain']);
                            if ( ! empty ($args['path']) )
                                $mysql_query    .=  $wpdb->prepare(" AND path = %s", $args['path']);
                        }
                        
                    if ( ! empty ($args['exclude'])  &&  is_array($args['exclude']) &&  count ( $args['exclude'] ) > 0 )
                        {
                            $mysql_query    .=  " AND id NOT IN ( '". implode($args['exclude'], ',') ."')";
                        }
                        
                    
                    //Offset
                    if (  ! empty ($args['number']) &&  $args['number'] > 0 )
                        {
                            $mysql_query    .=   $wpdb->prepare( " LIMIT %d", $args['offset'] );
                            if  ( $args['number']   >   0 ) 
                                $mysql_query    .=   $wpdb->prepare(", %d" , $args['number']);
                        }
                    
                    $results        =   $wpdb->get_results( $mysql_query, ARRAY_A  ); 
                    $total_founds   =   $wpdb->get_var('SELECT FOUND_ROWS()');      
                            
                    return array(
                                    'items'         =>  $results,
                                    'total_founds'  =>  $total_founds
                                    );
                    
                }
                
                
            /**
            * Check if domain is the main domain
            *     
            * @param mixed $domain
            */
            public function is_main_domain( $domain_id )
                {

                    //get the domain data by domain
                    $args = array(
                        'id'     => $domain_id,
                    );
                    $result = $this->get_domains( $args );
                    $domain_data = array_shift( $result['items'] );
                    
                    if ( $domain_data['id'] == "1" )
                        return TRUE;
                        
                    return FALSE;
                    
                }
                
                
                
            /**
            * Add a new domain to the site
            * 
            * @param mixed $newdomain
            * @param mixed $path
            * @param mixed $title
            * @param mixed $user_id
            * @param mixed $meta
            */
            public function add_domain( $domain, $path, $title, $description, $user_id, $meta )
                {
                    
                    $defaults = array(
                      
                    );
                    $meta = wp_parse_args( $meta, $defaults );

                    $domain = preg_replace( '/\s+/', '', sanitize_user( $domain, true ) );

                    $title          =   strip_tags( $title );
                    $description    =   strip_tags( $description );   
                    $user_id = (int) $user_id;

                    if ( empty($path) )
                        $path = '/';

                    // Check if the domain has been used already. We should return an error message.
                    if ( $this->domain_exists($domain, $path) )
                        return new WP_Error( 'blog_taken', __( 'Sorry, that site already exists!' ) );
     
     
                    global $wpdb;

                    $result = $wpdb->insert( $wpdb->prefix . "woocommerce_woomd_domains", array( 'domain' => $domain, 'path' => $path, 'registered' => current_time('mysql')) );
                    if ( ! $result )
                        return new WP_Error('mysql_insert_blog', __('Could not create site.'));

                    $blog_id = $wpdb->insert_id;
     
                    if ( empty ( $blog_id ) )
                        return new WP_Error('create_blog', __('Could not create site.'));

                    //$thiis->switch_to_blog($blog_id);

                    $this->install_blog( $blog_id, $domain, $title, $description );
                    $this->wp_install_defaults( $user_id );

                    //add_user_to_blog($blog_id, $user_id, 'administrator');
                 
                    do_action( 'woomd/wpmu_new_blog', $blog_id, $user_id, $domain, $path, $meta );

                    return $blog_id;    
                    
                }
                
            
            /**
            * Update domain details
            * 
            * @param mixed $domain_id
            * @param mixed $details
            */
            function update_domain_details( $domain_id, $details = array() ) 
                {
                    global $wpdb;

                    if ( empty($details) )
                        return false;

                    if ( is_object($details) )
                        $details = get_object_vars($details);

                    $current_details    =  $this->get_domain( $domain_id );
                    if ( empty($current_details) )
                        return false;

                    $current_details = get_object_vars($current_details);

                    $details = array_merge($current_details, $details);
                    $details['last_updated'] = current_time('mysql', true);

                    $update_details = array();
                    $fields = array( 'id', 'domain', 'path', 'registered', 'last_updated');
                    foreach ( array_intersect( array_keys( $details ), $fields ) as $field ) 
                        {
                            if ( 'path' === $field ) {
                                $details[ $field ] = trailingslashit( '/' . trim( $details[ $field ], '/' ) );
                            }

                            $update_details[ $field ] = $details[ $field ];
                        }

                    $result = $wpdb->update( $wpdb->base_prefix . "woocommerce_woomd_domains", $update_details, array('id' => $domain_id) );
                }
                
                
            /**
            * Install an empty blog.
            *
            * Creates the new blog tables and options. If calling this function
            * directly, be sure to use switch_to_blog() first, so that $wpdb
            * points to the new blog.
            *
            * @since MU (3.0.0)
            *
            * @global wpdb     $wpdb
            * @global WP_Roles $wp_roles
            *
            * @param int    $blog_id    The value returned by insert_blog().
            * @param string $blog_title The title of the new site.
            */
            function install_blog( $blog_id, $domain, $blog_title = '', $description    =   '' ) 
                {

                    global $wpdb, $wp_roles;

                    // Cast for security
                    $blog_id = (int) $blog_id;
                    
                    //create the required tables
                    $this->create_blog_tables( $blog_id );
                    
                    $scheme = parse_url( $domain, PHP_URL_SCHEME );
                    $scheme = empty( $scheme ) ? 'http' : $scheme;

                    $url        =   esc_url( $scheme . '://' . $domain );
                    $siteurl    = $home = untrailingslashit( $url );
                    
                    $this->switch_to_domain( $blog_id );
                    
                    update_option( 'siteurl', $siteurl );
                    update_option( 'home', $home );

                    update_option( 'blogname',          wp_unslash( $blog_title ) );
                    update_option( 'blogdescription',   wp_unslash( $description ) );
                    
                    update_option( 'admin_email', '' );
                    
                    //add default options
                    add_option('template',      '');
                    add_option('stylesheet',    '');
                    add_option('current_theme', '');
                    
                    $this->restore_current_domain();

                }
            
            
            
            
            /**
            * Creates the initial content for a newly-installed site.
            *
            * Adds the default "Uncategorized" category, the first post (with comment),
            * first page, and default widgets for default theme for the current version.
            *
            *
            * @global wpdb       $wpdb
            * @global WP_Rewrite $wp_rewrite
            * @global string     $table_prefix
            *
            * @param int $user_id User ID.
            */
            function wp_install_defaults( $user_id )
                {
                    
                    //+++++++++++++++++++++++++++++   
                    
                    
                }
                
            
            /**
            * Actions to take after domain delete
            *     
            * @param mixed $blog_id
            */
            function delete_domain( $domain_id )
                {
                    
                    global $wpdb;
                    
                    //delete the options table
                    $mysql_query    =   "DROP TABLE IF EXISTS " . $wpdb->prefix  . $domain_id ."_options";
                    $wpdb->get_results( $mysql_query );
                    
                    
                    //delete the domain from Domains table
                    $mysql_query    =   "DELETE FROM " . $wpdb->prefix . "woocommerce_woomd_domains
                                                WHERE id   =   " . $domain_id ;
                    $wpdb->get_results( $mysql_query );
                    
                }
            
                
            
            /**
            * Create additional tables
            * 
            */
            function create_blog_tables( $blog_id )
                {
                    global $wpdb;
                    
                    $charset_collate = $wpdb->get_charset_collate();
                    
                    $mysql_query    =   "CREATE TABLE " . $wpdb->prefix  . $blog_id ."_options (
                                              option_id bigint(20) unsigned NOT NULL auto_increment,
                                              option_name varchar(191) NOT NULL default '',
                                              option_value longtext NOT NULL,
                                              autoload varchar(20) NOT NULL default 'yes',
                                              PRIMARY KEY  (option_id),
                                              UNIQUE KEY option_name (option_name)
                                            ) $charset_collate;";
                    $wpdb->get_results( $mysql_query );   
                    
                    
                }
                            
                
            
            /**
            * Return a cleaned domain name
            * 
            * @param mixed $domain
            */
            public function prepare_domain( $domain )
                {
                    
                    $domain     =   str_replace(array('http://', 'https://'), "" , $domain );
                    
                    return $domain;
                    
                }
                  
            
            
            /**
            * Return current domain
            *     
            */
            static public function get_current_domain ()
                {
                    $current_domain = strtolower( stripslashes( $_SERVER['HTTP_HOST'] ) );
                    if ( substr( $current_domain, -3 ) == ':80' ) 
                        {
                            $current_domain               = substr( $current_domain, 0, -3 );
                            $_SERVER['HTTP_HOST'] = substr( $_SERVER['HTTP_HOST'], 0, -3 );
                        } 
                    elseif ( substr( $current_domain, -4 ) == ':443' ) 
                        {
                            $current_domain               = substr( $current_domain, 0, -4 );
                            $_SERVER['HTTP_HOST'] = substr( $_SERVER['HTTP_HOST'], 0, -4 );
                        }
                                        
                    return $current_domain;
                    
                }
                
                
            
            /**
            * Return domain records
            *     
            * @param mixed $domain
            */
            static public function get_domain_records ( )
                {
                    
                    $domain =   self::get_current_domain ();
                       
                    global $wpdb;
                    
                    $mysql_query    =   $wpdb->prepare ( "SELECT * FROM "    .   $wpdb->prefix  ."woocommerce_woomd_domains
                                                                WHERE domain    =   '%s'", $domain );
                    $domain_data         =   $wpdb->get_row( $mysql_query );
                    
                    return $domain_data;    
                    
                    
                }
                
            
            
            /**
            * Check if domain exists
            *     
            * @param mixed $domain
            * @param mixed $path
            */
            function domain_exists( $domain, $path )
                {
                    $path = trailingslashit( $path );
                    $args = array(
                        'domain'     => $domain,
                        'path'       => $path,
                        'fields'     => 'ids',
                        'number'     => 1,
                    );
                    $result = $this->get_domains( $args );
                    $result = array_shift( $result['items'] );

                    /**
                    * Filters whether a site name is taken.
                    *
                    * The name is the site's subdomain or the site's subdirectory
                    * path depending on the network settings.
                    *
                    * @since 3.5.0
                    *
                    * @param int|null $result     The site ID if the site name exists, null otherwise.
                    * @param string   $domain     Domain to be checked.
                    * @param string   $path       Path to be checked.
                    * @param int      $network_id Network ID. Relevant only on multi-network installations.
                    */
                    return apply_filters( 'woomd/domain_exists', $result, $domain, $path );   
                    
                }
            
                
                
            /**
            * Create a user.
            *
            * This function runs when a user self-registers as well as when
            * a Super Admin creates a new user. Hook to {@see 'wpmu_new_user'} for events
            * that should affect all new users, but only on Multisite (otherwise
            * use {@see'user_register'}).
            *
            * @since MU (3.0.0)
            *
            * @param string $user_name The new user's login name.
            * @param string $password  The new user's password.
            * @param string $email     The new user's email address.
            * @return int|false Returns false on failure, or int $user_id on success
            */
            function create_user( $user_name, $password, $email ) {
                //+++++++++++++
                $user_name = preg_replace( '/\s+/', '', sanitize_user( $user_name, true ) );

                $user_id = wp_create_user( $user_name, $password, $email );
                if ( is_wp_error( $user_id ) )
                    return false;

                // Newly created users have no roles or caps until they are added to a blog.
                delete_user_option( $user_id, 'capabilities' );
                delete_user_option( $user_id, 'user_level' );

                do_action( 'woomd/wpmu_new_user', $user_id );

                return $user_id;
            }
            
          
            
        }


?>