<?php
    
    //Load default constants
    woomd_plugin_directory_constants();
    
    
    function woomd_plugin_directory_constants()
        {
            $protocol   =   woomd_is_ssl()    ?   'https' :   'http';
            
            define('WP_SITEURL',    $protocol . '://' . $_SERVER['HTTP_HOST']);
            define('WP_HOME',       $protocol . '://' . $_SERVER['HTTP_HOST']);
            
            
            $current_domain = strtolower( stripslashes( $_SERVER['HTTP_HOST'] ) );
            if ( substr( $current_domain, -3 ) == ':80' ) 
                {
                    $current_domain               = substr( $current_domain, 0, -3 );
                    $_SERVER['HTTP_HOST'] = substr( $_SERVER['HTTP_HOST'], 0, -3 );
                } 
            elseif ( substr( $current_domain, -4 ) == ':443' ) 
                {
                    $current_domain               = substr( $current_domain, 0, -4 );
                    $_SERVER['HTTP_HOST'] = substr( $_SERVER['HTTP_HOST'], 0, -4 );
                }
            
            if ( ! defined( 'WP_CONTENT_URL' ) ) 
                {
                    define( 'WP_CONTENT_URL', $protocol . '://' .$current_domain . '/wp-content' ); // full url - WP_CONTENT_DIR is defined further up
                }

            /**
             * Allows for the plugins directory to be moved from the default location.
             *
             * @since 2.6.0
             */
            if ( ! defined( 'WP_PLUGIN_DIR' ) ) 
                {
                    define( 'WP_PLUGIN_DIR',  ABSPATH . 'wp-content/plugins' ); // full path, no trailing slash
                }

            /**
             * Allows for the plugins directory to be moved from the default location.
             *
             * @since 2.6.0
             */
            if ( ! defined( 'WP_PLUGIN_URL' ) ) 
                {
                    define( 'WP_PLUGIN_URL', WP_CONTENT_URL . '/plugins' ); // full url, no trailing slash
                }

            /**
             * Allows for the plugins directory to be moved from the default location.
             *
             * @since 2.1.0
             * @deprecated
             */
            if ( ! defined( 'PLUGINDIR' ) ) 
                {
                    define( 'PLUGINDIR', 'wp-content/plugins' ); // Relative to ABSPATH. For back compat.
                }

            /**
             * Allows for the mu-plugins directory to be moved from the default location.
             *
             * @since 2.8.0
             */
            if ( ! defined( 'WPMU_PLUGIN_DIR' ) ) 
                {
                    define( 'WPMU_PLUGIN_DIR',  ABSPATH . 'wp-content/mu-plugins' ); // full path, no trailing slash
                }

            /**
             * Allows for the mu-plugins directory to be moved from the default location.
             *
             * @since 2.8.0
             */
            if ( ! defined( 'WPMU_PLUGIN_URL' ) ) 
                {
                    define( 'WPMU_PLUGIN_URL', WP_CONTENT_URL . '/mu-plugins' ); // full url, no trailing slash
                }

            /**
             * Allows for the mu-plugins directory to be moved from the default location.
             *
             * @since 2.8.0
             * @deprecated
             */
            if ( ! defined( 'MUPLUGINDIR' ) ) 
                {
                    define( 'MUPLUGINDIR', 'wp-content/mu-plugins' ); // Relative to ABSPATH. For back compat.
                }    
        }
    
    function woomd_is_ssl() 
        {
            if ( isset( $_SERVER['HTTPS'] ) ) {
                if ( 'on' == strtolower( $_SERVER['HTTPS'] ) ) {
                    return true;
                }

                if ( '1' == $_SERVER['HTTPS'] ) {
                    return true;
                }
            } elseif ( isset( $_SERVER['SERVER_PORT'] ) && ( '443' == $_SERVER['SERVER_PORT'] ) ) {
                return true;
            }
            return false;
        }
        


    
?>