<?php
/*
Plugin Name: WooCommerce MultiDomain
Plugin URI: https://woomultidomain.com/
Description: Add multiple domain support and extended functionality for WooCommerce
Author: Nsp Code
Author URI: https://woomultidomain.com/
Version: 1.0.4
Text Domain: woo-multidomain
Domain Path: /languages/
WC requires at least: 3.0
WC tested up to: 5.9.0
*/


    define('WOOMULTID_PATH',                plugin_dir_path(__FILE__));
    define('WOOMULTID_URL',                 plugins_url('', __FILE__));

    define('WOOMULTID_VERSION',             '1.0.4');
    define('WOOMULTID_APP_API_URL',         'https://api.woomultidomain.com/'); 
    
    define('WOOMULTID_PRODUCT_ID',          'WooMultiDomain');
    define('WOOMULTID_INSTANCE',            preg_replace('/:[0-9]+/', '', str_replace(array ("https://" , "http://"), "", trim(network_site_url(), '/'))));
    
    //trigger sessions are expiring after 20 secconds
    define('WOOMD_TRIGGER_KEY_EXPIRE',      20 );
    
    //WooMD Global Cart cookie holder, 30 days as default
    define('WOOMD_COOKIE_EXPIRE',           30 * 24 * 60 * 60 );
    
    define('WOOMD_EXPECTED_MU_LOADER_VERSION',  1 );       
    
    require_once( WOOMULTID_PATH . '/includes/static-functions.php');
    
    //load language files
    add_action( 'plugins_loaded', 'woomultid_load_textdomain'); 
    function woomultid_load_textdomain() 
        {
            load_plugin_textdomain('woo-multidomain', FALSE, dirname( plugin_basename( __FILE__ ) ) . '/languages');
        }
    
    include_once( WOOMULTID_PATH . '/includes/class.functions.php' );    
    include_once( WOOMULTID_PATH . '/includes/class.woo-multidomain.php' );   
    include_once( WOOMULTID_PATH . '/includes/class.licence.php' );
    
    //plugin updater
    include_once( WOOMULTID_PATH . '/includes/class.plugin-updater.php');
    
    register_activation_hook(   __FILE__, 'WOOMULTID_activated');
    register_deactivation_hook( __FILE__, 'WOOMULTID_deactivated');

    function WOOMULTID_activated( $network_wide ) 
        {
            
            $options    =   Woo_MultiDomain_Functions::get_options();
                    
            $version =   WOOMULTID_VERSION;
            $options['version'] =   $version;
            
            Woo_MultiDomain_Functions::create_tables();
            Woo_MultiDomain_Functions::check_wp_config();
            Woo_MultiDomain_Functions::copy_mu_loader( TRUE );           
            
            Woo_MultiDomain_Functions::update_options( $options );
        
        }

    function WOOMULTID_deactivated() 
        {
           
            //replace the mu-loader
            Woo_MultiDomain_Functions::unlink_mu_loader();
            Woo_MultiDomain_Functions::clean_with_markers( Woo_MultiDomain_Functions::get_wp_config_path() , 'WooCommerce MultiDomain' );
            
        }
    
    global $woo_multidomain;
    $woo_multidomain    =   new Woo_MultiDomain();               
    $woo_multidomain->init();  
 

?>