<?php
    /**
    * Name:         Yoast SEO
    * Since:        17.2
    */

    
    if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
    
    class WooMD_wp_seo
        {
           
            function __construct( $dependencies = array() ) 
                {
                    
                    add_filter ( 'wpseo_posts_where', array ( $this, 'wpseo_posts_where'), 10, 2 );
                      
                }
          
            
            function wpseo_posts_where( $where, $post_type )
                {
                    if ( ! in_array ( $post_type , Woo_General_Content::$seek_post_types ) )
                        return $where;
                    
                    global $blog_id, $wpdb;
                    
                    $include_IDs    =   Woo_General_Content::get_objects_to_include( $blog_id );
                         
                    $post__in = implode( ',', array_map( 'absint', $include_IDs ) );
                    $where   .= " AND {$wpdb->posts}.ID IN ($post__in)";
                    
                    return $where;
                }
            
        }

    new WooMD_wp_seo();

?>