<?php


    if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

    function woomd_admin_bar_my_domains_menu( $wp_admin_bar ) 
        {
            // Don't show for logged out users or single site mode.
            if ( ! is_user_logged_in() )
                return;

            global $woo_multidomain;
                
            $my_sites_url = admin_url( 'admin.php?page=woo-multidomain' );

            $wp_admin_bar->add_menu( array(
                'id'    => 'my-sites',
                'title' => __( 'My Domains' ),
                'href'  => $my_sites_url,
            ) );
                    // Add site links
            $wp_admin_bar->add_group( array(
                'parent' => 'my-sites',
                'id'     => 'my-sites-list',
                'meta'   => array(
                    'class' => 'ab-sub-secondary',
                ),
            ) );
       
        
            $args           =   array ( );
            $data           =   $woo_multidomain->functions->network->get_domains( $args );
            $all_domains    =   $data['items'];
       
            foreach ( $all_domains as $domain ) 
                {
                    $woo_multidomain->functions->network->switch_to_domain( $domain['id'] );

                    $blavatar   =   '<div class="blavatar"></div>';

                    $blogname   =   get_option('blogname');

                    if ( ! $blogname ) {
                        $blogname = preg_replace( '#^(https?://)?(www.)?#', '', get_home_url() );
                    }

                    $menu_id  = 'blog-' . $domain['id'];

                    if ( current_user_can( 'read' ) ) {
                        $wp_admin_bar->add_menu( array(
                            'parent'    => 'my-sites-list',
                            'id'        => $menu_id,
                            'title'     => $blavatar . $blogname,
                            'href'      => admin_url(),
                        ) );

                        $wp_admin_bar->add_menu( array(
                            'parent' => $menu_id,
                            'id'     => $menu_id . '-d',
                            'title'  => __( 'Dashboard' ),
                            'href'   => admin_url(),
                        ) );
                    } 

                
                    $wp_admin_bar->add_menu( array(
                        'parent' => $menu_id,
                        'id'     => $menu_id . '-v',
                        'title'  => __( 'Visit Site' ),
                        'href'   => home_url( '/' ),
                    ) );

                    $woo_multidomain->functions->network->restore_current_domain();
                }
        }


?>