<?php

    if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
    
    class WooMD_All_Domains
        {
            var $functions;
            var $woomd_network;
            
            var $wp_list_table;
            
            var $current_section;
            
            function __construct()
                {
                    global $woo_multidomain;
                    
                    $this->functions        =   $woo_multidomain->functions;
                    $this->woomd_network    =   $woo_multidomain->functions->network;   
                                    
                }
                
            
            function init()
                {
                    
                    $this->run();
                    
                    if ( $this->current_section     ==  'all-domains' )
                        $this->output();
                    
                }
                
            static function load()
                {
                    //add option per screen items
                    $option = 'per_page';
 
                    $args = array(
                                    'label'     => 'Domains',
                                    'default'   => 20,
                                    'option'    => 'woomd_domains_per_page'
                                );
                     
                    add_screen_option( $option, $args );   
                    
                    
                }
                
            /**
            * Save the per-screen option
            * 
            * @param mixed $status
            * @param mixed $option
            * @param mixed $value
            */
            function set_screen_option( $status, $option, $value )
                {
                        
                    if ( 'woomd_domains_per_page' == $option ) 
                        return array ( TRUE, $value );

                    return array ( FALSE, $status ) ;
                
                }      
    
    
            static function set_screen_data()
                {

                    get_current_screen()->add_help_tab(
                                                        array(
                                                            'id'      => 'overview',
                                                            'title'   => __( 'Overview' ),
                                                            'content' =>
                                                                '<p>' . __( 'Add New Domain takes you to the Add New Domain screen. You can search for a site by Name or ID number. Screen Options allows you to choose how many sites to display on one page.' ) . '</p>' .
                                                                '<p>' . __( 'This is the main table of all domains on this hub. Switch between list and excerpt views by using the icons above the right side of the table.' ) . '</p>' .
                                                                '<p>' . __( 'Hovering over each domain reveals the options (three for the primary site):' ) . '</p>' .
                                                                '<ul><li>' . __( 'An Edit link to a separate Edit Site screen.' ) . '</li>' .
                                                                '<li>' . __( 'Dashboard leads to the Dashboard for that site.' ) . '</li>' .
                                                                '<li>' . __( 'Delete which is a permanent action after the confirmation screens.' ) . '</li>' .
                                                                '<li>' . __( 'Visit to go to the front-end site live.' ) . '</li></ul>' .
                                                                '<p>' . __( 'The site ID is used internally, and is not shown on the front end of the site or to users/viewers.' ) . '</p>' .
                                                                '<p>' . __( 'Clicking on bold headings can re-sort this table.' ) . '</p>',
                                                        )
                                                    );

                    get_current_screen()->set_help_sidebar(
                        '<p><strong>' . __('For more information:') . '</strong></p>' 
                        . '<p>' . __('Visit plugin vebsite') . '</p>'
                    );
            
                    
                }
                
            
            function run()
                {
                        
                    if  (  isset ( $_GET['section'] ) &&     $_GET['section']   =   'domain-edit' )
                        {
                            include_once( WOOMULTID_PATH . '/includes/admin/domain-edit.php' );
                            $instance   =   new WooMD_Domain_Edit();
                            $instance->init();
                            
                            $this->current_section  =   'domain-edit';
                            
                            return;
                        }
                    
                    $this->current_section  =   'all-domains';
                    
                    include_once( WOOMULTID_PATH . '/includes/admin/class-wp-domains-list-table.php' ); 
                    
                    $this->wp_list_table  =   new WP_Domains_List_Table();
                    
                    $pagenum = $this->wp_list_table->get_pagenum();
                    
                    $id = isset( $_REQUEST['id'] ) ? intval( $_REQUEST['id'] ) : 0;

                    if ( isset( $_GET['action'] ) ) 
                        {
                            do_action( 'woomd/wpmuadminedit' );

                            $manage_actions = array(
                                    'deleteblog'     => __( 'You are about to delete the site %s.' ),
                                );

                            if ( 'confirm' === $_GET['action'] ) 
                                {
                                    // The action2 parameter contains the action being taken on the site.
                                    $site_action = $_GET['action2'];

                                    if ( ! array_key_exists( $site_action, $manage_actions ) ) {
                                        wp_die( __( 'The requested action is not valid.' ) );
                                    }

                                    // The mature/unmature UI exists only as external code. Check the "confirm" nonce for backward compatibility.
                                    if ( 'matureblog' === $site_action || 'unmatureblog' === $site_action ) {
                                        check_admin_referer( 'confirm' );
                                    } else {
                                        check_admin_referer( $site_action . '_' . $id );
                                    }

                                    if ( ! headers_sent() ) {
                                        nocache_headers();
                                        header( 'Content-Type: text/html; charset=utf-8' );
                                    }

                                    if ( 1 == $id ) {
                                        wp_die( __( 'Sorry, you are not allowed to change the current site.' ) );
                                    }

                                    $domain_details = $this->woomd_network->get_domain( $id );
                                    $site_address = untrailingslashit( $domain_details->domain . $domain_details->path );

                                    require_once( ABSPATH . 'wp-admin/admin-header.php' );
                                    ?>
                                        <div class="wrap">
                                            <h1><?php _e( 'Confirm your action' ); ?></h1>
                                            <form action="admin.php?page=woo-multidomain&action=<?php echo esc_attr( $site_action ); ?>" method="post">
                                                <input type="hidden" name="action" value="<?php echo esc_attr( $site_action ); ?>" />
                                                <input type="hidden" name="id" value="<?php echo esc_attr( $id ); ?>" />
                                                <input type="hidden" name="_wp_http_referer" value="<?php echo esc_attr( wp_get_referer() ); ?>" />
                                                <?php wp_nonce_field( $site_action . '_' . $id, '_wpnonce', false ); ?>
                                                <p><?php echo sprintf( $manage_actions[ $site_action ], $site_address ); ?></p>
                                                <?php submit_button( __( 'Confirm' ), 'primary' ); ?>
                                            </form>
                                        </div>
                                    <?php
                                    require_once( ABSPATH . 'wp-admin/admin-footer.php' );
                                    exit();
                                } 
                                elseif ( array_key_exists( $_GET['action'], $manage_actions ) ) 
                                {
                                    $action = $_GET['action'];
                                    check_admin_referer( $action . '_' . $id );
                                } 
                                elseif ( 'allblogs' === $_GET['action'] ) 
                                {
                                    check_admin_referer( 'bulk-domains' );
                                }

                            $updated_action = '';

                            switch ( $_GET['action'] ) 
                                {
                         
                                    case 'delete_domains':
                                        check_admin_referer( 'ms-delete-domains' );

                                        global $blog_id;
                                        
                                        foreach ( (array) $_POST['site_ids'] as $domain_id ) 
                                            {
                                                $domain_id = (int) $domain_id;

                                                if ( $domain_id == $blog_id ) {
                                                    break;
                                                }
                                                
                                                $updated_action = 'all_delete';
                                                $this->woomd_network->delete_domain( $domain_id );
                                            }
                                        break;
                                        
                                    case 'deleteblog':
                                        global $blog_id;
                                        
                                        $domain_id = (int) $_POST['id'];

                                        if ( $domain_id == $blog_id ) {
                                            break;
                                        }
       
                                        $this->woomd_network->delete_domain( $domain_id );
                                        
                                        break;

                                    case 'allblogs':
                                        if ( ( isset( $_POST['action'] ) || isset( $_POST['action2'] ) ) && isset( $_POST['allblogs'] ) ) 
                                            {
                                                $doaction = $_POST['action'] != -1 ? $_POST['action'] : $_POST['action2'];

                                                foreach ( (array) $_POST['allblogs'] as $key => $val ) 
                                                    {
                                                        switch ( $doaction ) {
                                                            case 'delete':
                                                                require_once( ABSPATH . 'wp-admin/admin-header.php' );
                                                                ?>
                                                                <div class="wrap">
                                                                    <h1><?php _e( 'Confirm your action' ); ?></h1>
                                                                    <form action="admin.php?page=woo-multidomain&action=delete_domains" method="post">
                                                                        <input type="hidden" name="action" value="delete_domains" />
                                                                        <input type="hidden" name="_wp_http_referer" value="<?php echo esc_attr( wp_get_referer() ); ?>" />
                                                                        <?php wp_nonce_field( 'ms-delete-domains', '_wpnonce', false ); ?>
                                                                        <p><?php _e( 'You are about to delete the following domains:' ); ?></p>
                                                                        <ul class="ul-disc">
                                                                            <?php foreach ( $_POST['allblogs'] as $domain_id ) {
                                                                                $site = $this->woomd_network->get_domain( $domain_id );
                                                                                $site_address = untrailingslashit( $site->domain . $site->path );
                                                                                ?>
                                                                                <li>
                                                                                    <?php echo $site_address; ?>
                                                                                    <input type="hidden" name="site_ids[]" value="<?php echo (int) $domain_id; ?>" />
                                                                                </li>
                                                                            <?php } ?>
                                                                        </ul>
                                                                        <?php submit_button( __( 'Confirm' ), 'primary' ); ?>
                                                                    </form>
                                                                </div>
                                                                <?php
                                                                require_once( ABSPATH . 'wp-admin/admin-footer.php' );
                                                                exit();
                                                            break;
                                                   
                                                        }
                                                     
                                                    }
                                                if ( ! in_array( $doaction, array( 'delete', 'spam', 'notspam' ), true ) ) 
                                                    {
                                                        $redirect_to = wp_get_referer();
                                                        $blogs = (array) $_POST['allblogs'];
                                                        $redirect_to = apply_filters( 'woomd/handle_network_bulk_actions-' . get_current_screen()->id, $redirect_to, $doaction, $blogs, $id );
                                                        wp_safe_redirect( $redirect_to );
                                                        exit();
                                                    }
                                            } 
                                    break;

                                   
                                }

                            if ( empty( $updated_action ) && array_key_exists( $_GET['action'], $manage_actions ) ) 
                                {
                                    $updated_action = $_GET['action'];
                                }

                            if ( ! empty( $updated_action ) ) 
                                {
                                    wp_safe_redirect( add_query_arg( array( 'updated' => $updated_action ), wp_get_referer() ) );
                                    exit();
                                }
                        }

                    $msg = '';
                    if ( isset( $_GET['updated'] ) ) 
                        {
                            switch ( $_GET['updated'] ) {
                               
                                case 'all_delete':
                                    $msg = __( 'Domains deleted.' );
                                break;
                                case 'delete':
                                    $msg = __( 'Domain deleted.' );
                                break;
                                case 'not_deleted':
                                    $msg = __( 'Sorry, you are not allowed to delete that domain.' );
                                break;
                                case 'domain_created':
                                    $msg = __( 'Domain created.' );
                                break;
                                default:
                                    
                                    $msg = apply_filters( 'woomd/network_sites_updated_message_' . $_GET['updated'], __( 'Settings saved.' ) );
                                break;
                            }

                            if ( ! empty( $msg ) )
                                $msg = '<div id="message" class="updated notice is-dismissible"><p>' . $msg . '</p></div>';
                        }
                }
                
                
            function output()
                {

                    $this->wp_list_table->prepare_items();
                             
                    ?>

                        <div class="wrap">
                            <h1 class="wp-heading-inline"><?php _e( 'All Domains' ); ?></h1>

                            <a href="<?php echo admin_url('admin.php?page=woo-multidomain-add'); ?>" class="page-title-action"><?php echo esc_html_x( 'Add New', 'site' ); ?></a>

                            <?php
                            if ( isset( $_REQUEST['s'] ) && strlen( $_REQUEST['s'] ) ) 
                                {
                                    $s = isset( $_REQUEST['s'] ) ? wp_unslash( trim( $_REQUEST[ 's' ] ) ) : '';
                                    
                                    printf( '<span class="subtitle">' . __( 'Search results for &#8220;%s&#8221;' ) . '</span>', esc_html( $s ) );
                                }
                            ?>

                            <hr class="wp-header-end">

                            <form method="get" id="ms-search" action="admin.php?page=woo-multidomain">
                                <?php $this->wp_list_table->search_box( __( 'Search Domains' ), 'site' ); ?>
                                <input type="hidden" name="action" value="blogs" />
                                <input type="hidden" name="page" value="woo-multidomain" />
                            </form>

                            <form id="form-site-list" action="admin.php?page=woo-multidomain&action=allblogs" method="post">
                                <?php $this->wp_list_table->display(); ?>
                            </form>
                        </div>
                        
                    <?php

                }

        }

?>

