<?php
    
    if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
    
    class WooMD_Domain_Edit_Settings
        {
            var $functions;
            var $woomd_network;
            
            function __construct()
                {
                    global $woo_multidomain;
                    
                    $this->functions        =   $woo_multidomain->functions;
                    $this->woomd_network    =   $woo_multidomain->functions->network;
                    
                }
                
                
            function init()
                {
                    
                    $this->run();
                    $this->output();
                    
                }
                
                
            function run()
                {
                    global $woo_multidomain;

                    $id = isset( $_REQUEST['id'] ) ? intval( $_REQUEST['id'] ) : 0;

                    if ( ! $id ) {
                        wp_die( __( 'Invalid site ID.' ) );
                    }

                    $details = $this->woomd_network->get_domain( $id );
                    if ( ! $details ) {
                        wp_die( __( 'The requested domain does not exist.' ) );
                    }
     
                    if ( isset( $_REQUEST['action'] ) && 'update-domain' == $_REQUEST['action'] && is_array( $_POST['option'] ) ) 
                        {
                            check_admin_referer( 'edit-domain' );

                            $this->woomd_network->switch_to_domain( $id );

                            $skip_options = array( 'allowedthemes' ); // Don't update these options since they are handled elsewhere in the form.
                            foreach ( (array) $_POST['option'] as $key => $val ) 
                                {
                                    $key = wp_unslash( $key );
                                    $val = wp_unslash( $val );
                                    if ( $key === 0 || is_array( $val ) || in_array( $key, $skip_options ) ) {
                                        continue; // Avoids "0 is a protected WP option and may not be modified" error when edit blog options
                                    }
                                    update_option( $key, $val );
                                }

                            /**
                             * Fires after the site options are updated.
                             *
                             * @since 3.0.0
                             * @since 4.4.0 Added `$id` parameter.
                             *
                             * @param int $id The ID of the site being updated.
                             */
                            do_action( 'woomd/wpmu_update_blog_options', $id );

                            $this->woomd_network->restore_current_domain();
                            
                            wp_redirect(
                                add_query_arg(
                                    array(
                                        'page'      =>  'woo-multidomain',
                                        'section'   =>  'domain-edit',
                                        'tab'       =>  'domain-settings',
                                        'update'    => 'updated',
                                        'id'        => $id,
                                    ),
                                    'admin.php'
                                )
                            );
                            exit;
                        }   
                    
                }
                
                
            function output()
                {
                    global $woo_multidomain;

                    $id = isset( $_REQUEST['id'] ) ? intval( $_REQUEST['id'] ) : 0;

                    $details = $this->woomd_network->get_domain( $id );
                    if ( ! $details ) {
                        wp_die( __( 'The requested domain does not exist.' ) );
                    }
                    
                    /* translators: %s: site name */
                    $title = sprintf( __( 'Edit Domain: %s' ), esc_html( $details->blogname ) );  

                    ?>

                    <div class="wrap">
                        <h1 id="edit-site"><?php echo $title; ?></h1>
                        <p class="edit-site-actions"><a href="<?php echo esc_url( get_home_url( $id, '/' ) ); ?>"><?php _e( 'Visit' ); ?></a> | <a href="<?php echo esc_url( get_admin_url( $id ) ); ?>"><?php _e( 'Dashboard' ); ?></a></p>
                        <?php
                        

                        $current_tab    =   isset($_GET['tab']) ? $_GET['tab']    :   'domain-info'; 
                        
                        $woo_multidomain->admin_interface->network_edit_domain_nav(
                                                                            array(
                                                                                'blog_id'  => $id,
                                                                                'selected' => $current_tab,
                                                                            )
                                                                        );
                        
                        $is_main_site = $id < 2 ?   TRUE    :   FALSE;

                        if ( isset( $_GET['update'] ) ) 
                            {
                                $messages = array();
                                if ( 'updated' == $_GET['update'] ) 
                                    {
                                        $messages[] = __( 'Domain options updated.' );
                                    }
                            }
                        

                        if ( ! empty( $messages ) ) 
                            {
                                foreach ( $messages as $msg ) {
                                    echo '<div id="message" class="updated notice is-dismissible"><p>' . $msg . '</p></div>';
                                }
                            }
                        ?>
                        <form method="post" action="admin.php?page=woo-multidomain&section=domain-edit&tab=domain-settings&action=update-domain">
                            <?php wp_nonce_field( 'edit-domain' ); ?>
                            <input type="hidden" name="id" value="<?php echo esc_attr( $id ); ?>" />
                            <table class="form-table">
                                <?php
                                
                                global $wpdb;
                                
                                $blog_prefix = $this->woomd_network->wpdb_get_blog_prefix ( $id );
                                $sql         = "SELECT * FROM {$blog_prefix}options
                                    WHERE option_name NOT LIKE %s
                                    AND option_name NOT LIKE %s";
                                $query       = $wpdb->prepare(
                                                                $sql,
                                                                $wpdb->esc_like( '_' ) . '%',
                                                                '%' . $wpdb->esc_like( 'user_roles' )
                                                            );
                                $options     = $wpdb->get_results( $query );
                                foreach ( $options as $option ) 
                                    {
                                        if ( $option->option_name == 'default_role' ) 
                                            {
                                                $editblog_default_role = $option->option_value;
                                            }
                                        $disabled = false;
                                        $class    = 'all-options';
                                        if ( is_serialized( $option->option_value ) ) 
                                            {
                                                if ( is_serialized_string( $option->option_value ) ) 
                                                    {
                                                        $option->option_value = esc_html( maybe_unserialize( $option->option_value ) );
                                                    } 
                                                else 
                                                    {
                                                        $option->option_value = 'SERIALIZED DATA';
                                                        $disabled             = true;
                                                        $class                = 'all-options disabled';
                                                    }
                                            }
                                        if ( strpos( $option->option_value, "\n" ) !== false ) 
                                            {
                                                ?>
                                                <tr class="form-field">
                                                    <th scope="row"><label for="<?php echo esc_attr( $option->option_name ); ?>"><?php echo ucwords( str_replace( '_', ' ', $option->option_name ) ); ?></label></th>
                                                    <td><textarea class="<?php echo $class; ?>" rows="5" cols="40" name="option[<?php echo esc_attr( $option->option_name ); ?>]" id="<?php echo esc_attr( $option->option_name ); ?>"<?php disabled( $disabled ); ?>><?php echo esc_textarea( $option->option_value ); ?></textarea></td>
                                                </tr>
                                                <?php
                                            } 
                                        else 
                                            {
                                                ?>
                                                <tr class="form-field">
                                                    <th scope="row"><label for="<?php echo esc_attr( $option->option_name ); ?>"><?php echo esc_html( ucwords( str_replace( '_', ' ', $option->option_name ) ) ); ?></label></th>
                                                    <?php if ( $is_main_site && in_array( $option->option_name, array( 'siteurl', 'home' ) ) ) { ?>
                                                    <td><code><?php echo esc_html( $option->option_value ); ?></code></td>
                                                    <?php } else { ?>
                                                    <td><input class="<?php echo $class; ?>" name="option[<?php echo esc_attr( $option->option_name ); ?>]" type="text" id="<?php echo esc_attr( $option->option_name ); ?>" value="<?php echo esc_attr( $option->option_value ); ?>" size="40" <?php disabled( $disabled ); ?> /></td>
                                                    <?php } ?>
                                                </tr>
                                                <?php
                                            }
                                    }
                                
                                do_action( 'woomd/wpmueditblogaction', $id );
                                ?>
                            </table>
                            <?php submit_button(); ?>
                        </form>
   
                    </div>
                    <?php
                }
                
        }
    
?>