<?php

    class Woo_MultiDomain_Functions 
        {
            
            var $network    =   '';
            
            
            function __construct()
                {
                    include_once( WOOMULTID_PATH . '/includes/class.network.php');
                    $this->network  =   new Woo_MultiDomain_Network();    
                    
                }
            
                           
            /**
            * Return Options
            * 
            */
            static public function get_options()
                {
                    
                    $_options   =   get_site_option('woo_multidomain_options');
                    
                    $defaults = array (
                                             'version'                                      =>  '1.0',
                                             
                                             'cart_checkout_type'                           =>  'single_checkout',
                                             'cart_checkout_location'                       =>  '',
                                             
                                             'hided_products_not_showing_on_domain'         =>  'yes',
                                             'allow_product_different_content'              =>  'no',
                                             'each_domain_posts_pages_content'              =>  'no',
                                             'load_all_dependencies_through_local_domain'   =>  'yes'
                                             
                                       );
                    
                    $options = wp_parse_args( $_options, $defaults );
                          
                    return $options;  
                    
                }
            
            /**
            * Update Options
            *     
            * @param mixed $options
            */
            static public function update_options($options)
                {
                    
                    update_site_option('woo_multidomain_options', $options);
                    
                    
                }
            
            
            /**
            * Retrieve the current site ID.
            *
            * @since 3.1.0
            *
            * @global int $blog_id
            *
            * @return int Site ID.
            */
            function get_current_blog_id() {
                global $blog_id;
                return absint($blog_id);
            }
            
                 
                
            function is_plugin_active( $plugin_slug )
                {
                    
                    include_once ( ABSPATH.'wp-admin/includes/plugin.php' );
                    
                    return ( is_plugin_active( $plugin_slug ) );
                    
                }
                
                
            
            /**
            * Define the plugin required constants
            * 
            */
            static function define_constants()
                {
                    
                    $options    =   self::get_options();
                        
                    define('WOOMD_OPTIONS_SETUP_TYPE', 2 );
        
                    if ( $options['hided_products_not_showing_on_domain']   ==  'yes' )
                        define( 'WOOMD_WHEN_PRODUCT_HIDED_DO_NOT_SHOW_ON_SHOP_DASHBOARD_TOO',    TRUE );
                        else
                        define( 'WOOMD_WHEN_PRODUCT_HIDED_DO_NOT_SHOW_ON_SHOP_DASHBOARD_TOO',    FALSE );
                    
                    if ( $options['allow_product_different_content']   ==  'yes' )
                        define( 'WOOMD_ALLOW_PRODUCT_DIFFERENT_CONTENT_ON_DOMAINS',              TRUE );
                        else
                        define( 'WOOMD_ALLOW_PRODUCT_DIFFERENT_CONTENT_ON_DOMAINS',              FALSE );
                    
                    if ( $options['each_domain_posts_pages_content']   ==  'yes' )
                        define( 'WOOMD_EACH_DOMAIN_CONTENT',          TRUE );
                        else
                        define( 'WOOMD_EACH_DOMAIN_CONTENT',          FALSE );
                    
                }
            
            
            /**
            * Return the list of ignored options, which will be saved infdividually for each doamin
            * 
            */
            static public function get_ignore_options()
                {
                    
                    $woomd_ignore_options    =   array(
                                                                    'siteurl',
                                                                    'home',
                                                                    'blogname',
                                                                    'blogdescription',
                                                                    'current_theme',
                                                                    'template',
                                                                    'stylesheet',
                                                                    
                                                                    'theme_mods_%',
                                                                    'sidebars_widgets',
                                                                    'widget%',
                                                                    'woocommerce_%',
                                                                                     
                                                                    'page_on_front',
                                                                    'show_on_front'
                                                                    
                                                                    
                                                                    );
                                                                    
                    $woomd_ignore_options    =   apply_filters( 'woomd/ignore_options',     $woomd_ignore_options );
                    
                    return $woomd_ignore_options;
                
                
                }
                    
            
            /**
            * Start-up initialisation
            *     
            */
            static function startup()
                {
                    
                    include_once( WP_PLUGIN_DIR. '/woocommerce-multidomain/includes/class.network.php' );
                    $network_class_instance =   new Woo_MultiDomain_Network();
                    
                    if ( ! $network_class_instance->is_current_domain_setup() )
                        return FALSE;
                       
                    remove_filter( 'option_siteurl', '_config_wp_siteurl' );
                    remove_filter( 'option_home',    '_config_wp_home'    );

                    include_once( WP_PLUGIN_DIR. '/woocommerce-multidomain/includes/class.cache.php') ;
                    
                    global $wp_object_cache;
                    $wp_object_cache    =   new WooMD_WP_Object_Cache();
                    
                    $curent_domain          =   $network_class_instance->get_domain_records();
                    $network_class_instance->switch_to_domain( $curent_domain->id );
                    $GLOBALS['switched']    =   FALSE;
                                                                                        
                    global $WooMD__MU_Module;;
                        
                    $main_domain_details   =   $network_class_instance->get_domain( 1 );
                        
                    require_once(  WP_PLUGIN_DIR . '/woocommerce-multidomain/includes/static-functions.php' );
                         
                    if ( ! defined( 'COOKIEHASH' ) ) 
                        {
                            define( 'COOKIEHASH', md5( $main_domain_details->domain ) );
                        }

                    if ( defined('COOKIE_DOMAIN') ) 
                        {
                            //we expect the cookie to be unefined  
                            $WooMD__MU_Module['issues'][]   =   'e01';
                        }                                                
                    
                    include_once( WP_PLUGIN_DIR. '/woocommerce-multidomain/includes/startup-filters.php') ;
                    
                }
                
                
                
            public function setup_separate_content ( $post_types )
                {
                    
                    $post_types =   filter_var_array( $post_types, FILTER_SANITIZE_STRING);
                     
                    global $wpdb;
                    
                    $mysql_query    =   "INSERT INTO `". $wpdb->postmeta ."`(
                                            `meta_id`,
                                            `post_id`,
                                            `meta_key`,
                                            `meta_value`
                                        )
                                        SELECT NULL AS
                                            meta_id,
                                            ID,
                                            'woomd_site_id' AS meta_key,
                                            1 AS meta_value
                                        FROM
                                            ". $wpdb->posts ." AS p
                                        LEFT JOIN ". $wpdb->postmeta ." AS pm
                                        ON
                                            p.ID = pm.post_id
                                        WHERE
                                            p.ID NOT IN(
                                            SELECT
                                                ID
                                            FROM
                                                ". $wpdb->posts ." AS p
                                            LEFT JOIN ". $wpdb->postmeta ." AS pm
                                            ON
                                                p.ID = pm.post_id
                                            WHERE
                                                p.post_type IN( '". implode( "','" , $post_types ) ."' ) AND pm.meta_key = 'woomd_site_id'
                                            GROUP BY
                                                p.ID
                                        ) AND p.post_type IN( '". implode( "','" , $post_types ) ."' )
                                        GROUP BY
                                                p.ID";
                    
                    $wpdb->get_results( $mysql_query );

                }
            
            
            /**
            * Ensure the wp-config.php include the required lines
            * 
            */
            static public function check_wp_config( $update    =   TRUE )
                {
                    
                    if ( defined('WOOMD_WPCONFIG_LOADER') &&  WOOMD_WPCONFIG_LOADER === TRUE )
                        return TRUE;
                        
                    $existing_data  =   self::extract_from_markers( self::get_wp_config_path() , 'WooCommerce MultiDomain');
                        
                    if (  count( $existing_data )    <   1  ||  count ( array_diff ( $existing_data, self::get_wp_config_data() ) ) > 0 )
                        {
                            if ( $update    )
                                {
                                    self::clean_with_markers( self::get_wp_config_path(), 'WP Hide & Security Enhancer' );
                                    $args   =   array(
                                                        'marker'            =>  'WooCommerce MultiDomain',
                                                        'insertion'         =>  self::get_wp_config_data(),
                                                        'after_marker'      =>  'define(\s+)?\((\s+)?\'ABSPATH\'',
                                                        'offset'            =>  1
                                                        );
                                    $status =   self::insert_with_markers( self::get_wp_config_path(),    $args );
                                    
                                    return $status;
                                }
                                else
                                return FALSE;
                        }
                        
                    return TRUE;  
                    
                    
                }
                
            /**
            * Return the wp-config.php path depending on WordPress set-up type
            * Some WordPress installs might have wp-config file outside root directory. one level up
            * 
            */
            static public function get_wp_config_path()
                {
                    if ( file_exists( ABSPATH . 'wp-config.php' ) ) 
                        {
                            return ( ABSPATH . 'wp-config.php' );

                        } 
                    elseif ( @file_exists( dirname( ABSPATH ) . '/wp-config.php' ) && ! @file_exists( dirname( ABSPATH ) . '/wp-settings.php' ) ) 
                        {
                            return ( dirname( ABSPATH ) . '/wp-config.php' );
                        }   
                }
                
                
            
            /**
            * Return the data to put o wp-config.php file
            * 
            */
            static public function get_wp_config_data()
                {
                    $root_path  =   '/';
                    
                    //Check if wp-config.php os actually one leve up relative to wordpress root directory
                    if  ( realpath ( ABSPATH )  !=  realpath ( dirname( self::get_wp_config_path() ) ) )
                        {
                            $subdirectory   =   str_replace( dirname( self::get_wp_config_path() ), '' , realpath(ABSPATH . '/') );
                            $subdirectory   =   wp_normalize_path( $subdirectory );
                            $subdirectory   =   ltrim( $subdirectory, '/' );
                            $subdirectory   =   trailingslashit($subdirectory);
                            
                            $root_path      .=  $subdirectory;
                        }
                    
                            
                    $data   =   array(  
                                        "define('WOOMD_WPCONFIG_LOADER',          TRUE);",
                                        "include_once( ( defined('WP_PLUGIN_DIR')    ?     WP_PLUGIN_DIR   .   '/woocommerce-multidomain/'    :      ( defined( 'WP_CONTENT_DIR') ? WP_CONTENT_DIR  :   dirname(__FILE__) . '" . $root_path  . "' . 'wp-content' )  . '/plugins/woocommerce-multidomain' ) . '/loader.php');"
                                        );
                                        
                    return $data;
                    
                }
                
            
            /**
            * Check if the plugin started through MU plugin loader
            * 
            */
            static public function is_muloader()
                {
                    
                    if ( defined( 'WOOMD_MULOADER_VERSION' ) )
                        return TRUE;

                    return FALSE;
                       
                }
            
            
                            
            /**
            * Check if MU files exists
            * 
            */
            public function check_mu_files()
                {
                    
                    if( file_exists(WPMU_PLUGIN_DIR . '/_woo-md.php' ))
                        return TRUE;
                        
                    return FALSE;
                    
                }
            
                
                
            /**
            * Attempt to copy the mu loader within mu-plugins folder
            * 
            */
            static function copy_mu_loader( $force_overwrite    =   FALSE   )
                {
                    
                    //check if mu-plugins folder exists
                    if(! is_dir( WPMU_PLUGIN_DIR ))
                        {
                            if (! wp_mkdir_p( WPMU_PLUGIN_DIR ) )
                                return;
                        }
                    
                    //check if file actually exists already
                    if( !   $force_overwrite    )
                        {
                            if( file_exists( WPMU_PLUGIN_DIR . '/_woo-md.php' ) )
                                return;
                        }
                        
                    //attempt to copy the file
                    @copy( WP_PLUGIN_DIR . '/woocommerce-multidomain/mu-loader/_woo-md.php', WPMU_PLUGIN_DIR . '/_woo-md.php' );
                }
                
            
            /**
            * Attempt to remove the mu loader
            *     
            */
            static function unlink_mu_loader()
                {
                    //check if file actually exists already
                    if( !file_exists(WPMU_PLUGIN_DIR . '/_woo-md.php' ))
                        return;
                        
                    //attempt to copy the file
                    @unlink ( WPMU_PLUGIN_DIR . '/_woo-md.php' );
                }

   
            /**
            * Check if the mu-loader is deployed and up to date
            * 
            */
            function check_mu_loader()
                {
                    
                    if  ( ! $this->is_muloader()   === FALSE || ( defined ( 'WOOMD_MULOADER_VERSION' )  && version_compare( WOOMD_MULOADER_VERSION, WOOMD_EXPECTED_MU_LOADER_VERSION, '<' ) ) )
                        $status =   self::copy_mu_loader( TRUE );
                    
                }
   
                
            /**
            * @desc 
            * 
            * Create plugin required tables
            * 
            */
            static function create_tables()
                {
                    global $wpdb;
                    
                    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
                    
                    $collate = $wpdb->get_charset_collate();
                    
                    $query = "CREATE TABLE IF NOT EXISTS `". $wpdb->prefix ."woocommerce_woomd_domains` (
                                        `id` int(11) NOT NULL,
                                          `domain` varchar(128) NOT NULL,
                                          `path` varchar(128) NOT NULL,
                                          `registered` datetime NOT NULL,
                                          `type` varchar(32) NOT NULL
                                        ) " . $collate;
                    dbDelta($query);
                    
                    $query = "ALTER TABLE `". $wpdb->prefix ."woocommerce_woomd_domains`
                                                ADD PRIMARY KEY (`id`);";
                    $wpdb->get_results( $query );
                    
                    $query = "ALTER TABLE `". $wpdb->prefix ."woocommerce_woomd_domains`
                                        MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;";
                    $wpdb->get_results( $query );
                    
                    $query = "CREATE TABLE IF NOT EXISTS `". $wpdb->base_prefix ."woocommerce_woomd_sessions` (
                              `session_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
                              `session_key` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
                              `woomd_session_key` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
                              `session_expiry` bigint(20) UNSIGNED NOT NULL,
                              `trigger_key` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
                              `trigger_key_expiry` bigint(20) UNSIGNED NOT NULL,
                              `trigger_user_hash` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
                                PRIMARY KEY (`session_id`),
                                UNIQUE KEY `woomd_session_key` (`woomd_session_key`) USING BTREE,
                                KEY `trigger_key` (`trigger_key`)
                            ) " . $collate;
                    dbDelta( $query );
          
                }
                
            
            /**
            * Return current url
            * 
            */
            function current_url()
                {
                    
                    $current_url    =   'http' . (isset($_SERVER['HTTPS']) ? 's' : '') . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
                    
                    return $current_url;
                    
                }
                
            /**
            * Remove Class Filter Without Access to Class Object
            * 
            * @param mixed $tag
            * @param mixed $class_name
            * @param mixed $method_name
            * @param mixed $priority
            */
            function remove_class_filter( $tag, $class_name = '', $method_name = '', $priority = 10 ) 
                {
                    
                    global $wp_filter;
                    
                    // Check that filter actually exists first
                    if ( ! isset( $wp_filter[ $tag ] ) ) 
                        return FALSE;
                        
                    /**
                    * If filter config is an object, means we're using WordPress 4.7+ and the config is no longer
                    * a simple array, rather it is an object that implements the ArrayAccess interface.
                    *
                    * To be backwards compatible, we set $callbacks equal to the correct array as a reference (so $wp_filter is updated)
                    *
                    * @see https://make.wordpress.org/core/2016/09/08/wp_hook-next-generation-actions-and-filters/
                    */
                    if ( is_object( $wp_filter[ $tag ] ) && isset( $wp_filter[ $tag ]->callbacks ) ) 
                        {
                            // Create $fob object from filter tag, to use below
                            $fob = $wp_filter[ $tag ];
                            $callbacks = &$wp_filter[ $tag ]->callbacks;
                        } 
                        else 
                        {
                            $callbacks = &$wp_filter[ $tag ];
                        }
                        
                    // Exit if there aren't any callbacks for specified priority
                    if ( ! isset( $callbacks[ $priority ] ) || empty( $callbacks[ $priority ] ) ) 
                        return FALSE;
                        
                    // Loop through each filter for the specified priority, looking for our class & method
                    foreach( (array) $callbacks[ $priority ] as $filter_id => $filter ) 
                        {
                            // Filter should always be an array - array( $this, 'method' ), if not goto next
                            if ( ! isset( $filter[ 'function' ]  ) ) 
                                continue;
                            
                            //remove static    
                            if ( ! is_array( $filter[ 'function' ] ) )
                                {
                                    if( $filter[ 'function' ]   ==  $class_name . '::'  .  $method_name)
                                        {
                                            unset( $callbacks[ $priority ][ $filter_id ] );
                                            return TRUE;   
                                        }
                                    continue;   
                                }
                                
                            // If first value in array is not an object, it can't be a class
                            if ( ! is_object( $filter[ 'function' ][ 0 ] ) ) 
                                continue;
                                
                            // Method doesn't match the one we're looking for, goto next
                            if ( $filter[ 'function' ][ 1 ] !== $method_name ) 
                                continue;
                                
                            // Method matched, now let's check the Class
                            if ( get_class( $filter[ 'function' ][ 0 ] ) === $class_name ) 
                                {
                                    // WordPress 4.7+ use core remove_filter() since we found the class object
                                    if( isset( $fob ) )
                                        {
                                            // Handles removing filter, reseting callback priority keys mid-iteration, etc.
                                            $fob->remove_filter( $tag, $filter['function'], $priority );
                                        } 
                                    else 
                                        {
                                            // Use legacy removal process (pre 4.7)
                                            unset( $callbacks[ $priority ][ $filter_id ] );
                                            
                                            // and if it was the only filter in that priority, unset that priority
                                            if ( empty( $callbacks[ $priority ] ) ) 
                                                {
                                                    unset( $callbacks[ $priority ] );
                                                }
                                                
                                            // and if the only filter for that tag, set the tag to an empty array
                                            if ( empty( $callbacks ) ) 
                                                {
                                                    $callbacks = array();
                                                }
                                                
                                            // Remove this filter from merged_filters, which specifies if filters have been sorted
                                            unset( $GLOBALS['merged_filters'][ $tag ] );
                                            
                                        }
                                        
                                    return TRUE;
                                    
                                }
                        }
                        
                    return FALSE;
                    
                }
            

            function remove_class_action( $tag, $class_name = '', $method_name = '', $priority = 10 ) 
                {
                    
                    $this->remove_class_filter( $tag, $class_name, $method_name, $priority );
                    
                }
                
            
            /**
            * Replace a filter / action from anonymous object
            * 
            * @param mixed $tag
            * @param mixed $class
            * @param mixed $method
            */
            function remove_anonymous_object_filter( $tag, $class, $method ) 
                {
                    $filters = false;

                    if ( isset( $GLOBALS['wp_filter'][$tag] ) )
                        $filters = $GLOBALS['wp_filter'][$tag];

                    if ( $filters )
                    foreach ( $filters as $priority => $filter ) 
                        {
                            foreach ( $filter as $identifier => $function ) 
                                {
                                    if ( ! is_array( $function ) )
                                        continue;
                                    
                                    if ( ! $function['function'][0] instanceof $class )
                                        continue;
                                    
                                    if ( $method == $function['function'][1] ) 
                                        {
                                            remove_filter($tag, array( $function['function'][0], $method ), $priority);
                                        }
                                }
                        }
                }
                
                
            function createInstanceWithoutConstructor($class)
                {
                    
                    $reflector  = new ReflectionClass($class);
                    $properties = $reflector->getProperties();
                    $defaults   = $reflector->getDefaultProperties();
                           
                    $serealized = "O:" . strlen($class) . ":\"$class\":".count($properties) .':{';
                    foreach ($properties as $property)
                        {
                            $name = $property->getName();
                            if($property->isProtected())
                                {
                                    $name = chr(0) . '*' .chr(0) .$name;
                                } 
                            elseif($property->isPrivate())
                                {
                                    $name = chr(0)  . $class.  chr(0).$name;
                                }
                            
                            $serealized .= serialize($name);
                            
                            if(array_key_exists($property->getName(),$defaults) )
                                {
                                    $serealized .= serialize($defaults[$property->getName()]);
                                } 
                            else 
                                {
                                    $serealized .= serialize(null);
                                }
                        }
                        
                    $serealized .="}";
                    
                    return unserialize($serealized);
                    
                }
                
                
                        /**
            * Parse plugin headers data
            *     
            * @param mixed $plugin_file
            * @param mixed $markup
            * @param mixed $translate
            */
            function get_plugin_data( $plugin_file, $markup = true, $translate = true ) 
                {

                    $default_headers = array(
                        'Name' => 'Plugin Name',
                        'PluginURI' => 'Plugin URI',
                        'Version' => 'Version',
                        'Description' => 'Description',
                        'Author' => 'Author',
                        'AuthorURI' => 'Author URI',
                        'TextDomain' => 'Text Domain',
                        'DomainPath' => 'Domain Path',
                        'Network' => 'Network',
                        // Site Wide Only is deprecated in favor of Network.
                        '_sitewide' => 'Site Wide Only',
                    );

                    $plugin_data = get_file_data( $plugin_file, $default_headers, 'plugin' );

                    // Site Wide Only is the old header for Network
                    if ( ! $plugin_data['Network'] && $plugin_data['_sitewide'] ) {
                        /* translators: 1: Site Wide Only: true, 2: Network: true */
                        _deprecated_argument( __FUNCTION__, '3.0', sprintf( __( 'The %1$s plugin header is deprecated. Use %2$s instead.' ), '<code>Site Wide Only: true</code>', '<code>Network: true</code>' ) );
                        $plugin_data['Network'] = $plugin_data['_sitewide'];
                    }
                    $plugin_data['Network'] = ( 'true' == strtolower( $plugin_data['Network'] ) );
                    unset( $plugin_data['_sitewide'] );

                    if ( $markup || $translate ) {
                        $plugin_data = $this->_get_plugin_data_markup_translate( $plugin_file, $plugin_data, $markup, $translate );
                    } else {
                        $plugin_data['Title']      = $plugin_data['Name'];
                        $plugin_data['AuthorName'] = $plugin_data['Author'];
                    }

                    return $plugin_data;
                }
                
                
            /**
            * Insert the data using markes in a specified file
            * 
            * @param mixed $filename
            * @param mixed $args
            * @return mixed
            */
            static public function insert_with_markers ( $filename, $args )
                {
                    
                    $defaults   = array (
                                            'marker'            =>  '',
                                            
                                            'insertion'         =>  '',
                                            
                                            'before_marker'     =>  '',
                                            'after_marker'      =>  '',
                                            
                                            'offset'            =>  0
                                        );
                                        
                    // Parse incoming $args into an array and merge it with $defaults
                    $args   =   wp_parse_args( $args, $defaults );
                    extract($args);
                       
                    if ( ! file_exists( $filename ) ) {
                        if ( ! is_writable( dirname( $filename ) ) ) {
                            return false;
                        }
                        if ( ! touch( $filename ) ) {
                            return false;
                        }
                    } elseif ( ! is_writeable( $filename ) ) {
                        return false;
                    }

                    if ( ! is_array( $insertion ) ) {
                        $insertion = explode( "\n", $insertion );
                    }

                    $start_marker = "# BEGIN {$marker}";
                    $end_marker   = "# END {$marker}";

                    $fp = fopen( $filename, 'r+' );
                    if ( ! $fp ) {
                        return false;
                    }

                    // Attempt to get a lock. If the filesystem supports locking, this will block until the lock is acquired.
                    flock( $fp, LOCK_EX );

                    $lines = array();
                    while ( ! feof( $fp ) ) {
                        $lines[] = rtrim( fgets( $fp ), "\r\n" );
                    }

                    // Split out the existing file into the preceding lines, and those that appear after the marker
                    $pre_lines = $post_lines = $existing_lines = array();
                    $found_marker = $found_end_marker = false;
                    foreach ( $lines as $line ) {
                        if ( ! $found_marker && false !== strpos( $line, $start_marker ) ) {
                            $found_marker = true;
                            continue;
                        } elseif ( ! $found_end_marker && false !== strpos( $line, $end_marker ) ) {
                            $found_end_marker = true;
                            continue;
                        }
                        if ( ! $found_marker ) {
                            $pre_lines[] = $line;
                        } elseif ( $found_marker && $found_end_marker ) {
                            $post_lines[] = $line;
                        } else {
                            $existing_lines[] = $line;
                        }
                    }

                    // Check to see if there was a change
                    if ( $existing_lines === $insertion ) {
                        flock( $fp, LOCK_UN );
                        fclose( $fp );

                        return true;
                    }

                    $offset_lines    =   array();
                    if ( $args['offset'] > 0 )
                        {
                            for ( $i = 1; $i <= $args['offset']; $i++ )
                                $offset_lines[]  =   "";
                        }
                    
                    // Generate the new file data
                    if( $found_marker && $found_end_marker )
                        {
                            $new_file_data = implode( "\n", array_merge(
                                $pre_lines,
                                $offset_lines,
                                array( $start_marker ),
                                $insertion,
                                array( $end_marker ),
                                $post_lines
                            ) );
                        }
                        else
                        {
                            $insert_at  =   FALSE;                            
                            if  ( ! empty ( $before_marker ) )
                                {
                                    $insert_at  =   array_search($before_marker, array_map("trim", $pre_lines) );
                                }
                            
                            if  ( $insert_at    === FALSE  &&  ! empty ( $after_marker ) )
                                {
                                    $founds = preg_grep ('/' . $after_marker . '/i', array_map("trim", $pre_lines) );
                                    
                                    if ( count  ( $founds ) > 0 )
                                        {
                                            reset ( $founds );
                                            $insert_at  =   key ( $founds );
                                            $insert_at++;
                                            
                                            //ensure the following line is not a closing braket
                                            if ( trim ( $lines[$insert_at] ) == '}' )
                                                $insert_at++;
                                        }
                                 }
                                
                            if  ( $insert_at  ===   FALSE )
                                $insert_at  =   0;

                            $pre_lines  =   array_merge( 
                                                            array_slice( $pre_lines, 0, $insert_at, TRUE),
                                                            $offset_lines,
                                                            array( $start_marker ),
                                                            $insertion,
                                                            array( $end_marker ),
                                                            array_slice( $pre_lines, $insert_at, count($pre_lines), TRUE)
                                                            );
                                
                            $new_file_data = implode( "\n", $pre_lines );        
                            
                        }

                    // Write to the start of the file, and truncate it to that length
                    fseek( $fp, 0 );
                    $bytes = fwrite( $fp, $new_file_data );
                    if ( $bytes ) {
                        ftruncate( $fp, ftell( $fp ) );
                    }
                    fflush( $fp );
                    flock( $fp, LOCK_UN );
                    fclose( $fp );

                    return (bool) $bytes;    
                    
                    
                }
            
            
            static public function extract_from_markers( $filename, $marker ) 
                {
                    $result = array ();

                    if ( ! file_exists( $filename ) ) 
                        {
                            return $result;
                        }

                    $markerdata = explode( "\n", implode( '', file( $filename ) ) );

                    $state = false;
                    foreach ( $markerdata as $markerline ) 
                        {
                            if ( false !== strpos( $markerline, '# END ' . $marker ) ) 
                                {
                                    $state = false;
                                }
                            if ( $state ) 
                                {
                                    $result[] = $markerline;
                                }
                            if ( false !== strpos( $markerline, '# BEGIN ' . $marker ) ) 
                                {
                                    $state = true;
                                }
                        }

                    return $result;
                } 
            
            static public function clean_with_markers( $filename, $marker)
                {
                    
                    if ( ! file_exists( $filename ) ) {
                        if ( ! is_writable( dirname( $filename ) ) ) {
                            return false;
                        }
                        if ( ! touch( $filename ) ) {
                            return false;
                        }
                    } elseif ( ! is_writeable( $filename ) ) {
                        return false;
                    }
              
                    $start_marker = "# BEGIN {$marker}";
                    $end_marker   = "# END {$marker}";

                    $fp = fopen( $filename, 'r+' );
                    if ( ! $fp ) {
                        return false;
                    }

                    // Attempt to get a lock. If the filesystem supports locking, this will block until the lock is acquired.
                    flock( $fp, LOCK_EX );

                    $lines = array();
                    while ( ! feof( $fp ) ) {
                        $lines[] = rtrim( fgets( $fp ), "\r\n" );
                    }

                    // Split out the existing file into the preceding lines, and those that appear after the marker
                    $pre_lines = $post_lines = $existing_lines = array();
                    $found_marker = $found_end_marker = false;
                    foreach ( $lines as $line ) {
                        if ( ! $found_marker && false !== strpos( $line, $start_marker ) ) {
                            $found_marker = true;
                            continue;
                        } elseif ( ! $found_end_marker && false !== strpos( $line, $end_marker ) ) {
                            $found_end_marker = true;
                            continue;
                        }
                        if ( ! $found_marker ) {
                            $pre_lines[] = $line;
                        } elseif ( $found_marker && $found_end_marker ) {
                            $post_lines[] = $line;
                        } else {
                            $existing_lines[] = $line;
                        }
                    }
                         
                    // Generate the new file data
                    if($found_marker && $found_end_marker)
                        {
                            $new_file_data = implode( "\n", array_merge(
                                $pre_lines,
                                $post_lines
                            ) );
                            
                            // Write to the start of the file, and truncate it to that length
                            fseek( $fp, 0 );
                            $bytes = fwrite( $fp, $new_file_data );
                            if ( $bytes ) {
                                ftruncate( $fp, ftell( $fp ) );
                            }
                            fflush( $fp );
                            flock( $fp, LOCK_UN );
                            fclose( $fp );

                            return (bool) $bytes; 
                            
                        }
                
                    return FALSE;   
                    
                    
                }
                
                
        }


?>