<?php



    class Woo_MultiDomain_general_filters
        {
            
            var $functions;
            var $woomd_network;
              
            function __construct()   
                {
                    global $woo_multidomain;
                    
                    $this->functions        =   $woo_multidomain->functions;
                    $this->woomd_network    =   $woo_multidomain->functions->network;
                        
                    add_filter ( 'woocommerce_get_order_item_classname',    array( $this, 'woocommerce_get_order_item_classname' ), 999, 3 );
                    
                    //filter the meta
                    add_filter( 'get_post_metadata',                         array($this, 'get_post_metadata'), 9999, 4);
                    
                    //Hide the product on domains
                    //add_filter( 'posts_request',                          array( $this, 'posts_request'),     9999, 2 );
                    add_filter( 'posts_clauses' ,                           array( $this, 'posts_clauses' ),    9999, 2); 
                    
                    //add the domain id to the order
                    add_action( 'woocommerce_new_order',                    array( $this, 'woocommerce_new_order'), 10, 2 );
                }
                
         
            function woocommerce_get_order_item_classname( $classname, $item_type, $id  )
                {
                    
                    include_once( WOOMULTID_PATH . '/includes/order/class.order-item-product.php' );
                            
                    switch ( $item_type ) 
                        {
                            case 'line_item' :
                            case 'product' :
                                $classname = 'Woo_MultiDomain_Order_Item_Product';
                            break;
                 
                        }
                        
                    return $classname;
                       
                }
                
            
            function get_post_metadata( $null, $object_id, $meta_key, $single )
                {
                    global $wpdb, $blog_id;
                    
                    //no need to run for main shop
                    if  ( $blog_id < 2 )
                        return $null;
                    
                    $allow_meta_keys  =   array(
                                            '_regular_price',
                                            '_sale_price',
                                            '_price'
                                            );
                                            
                    $_base_meta_key         =   str_replace( '_' .   $wpdb->base_prefix  .   $blog_id, '' , $meta_key);
                    
                    //only specific keys
                    if  ( !in_array($_base_meta_key , $allow_meta_keys))
                        return $null;
                    
                    $mysql_query    =   $wpdb->prepare( "SELECT meta_id FROM " . $wpdb->postmeta ."
                                                        WHERE post_id   =   %d  AND meta_key    =   %s", $object_id, $meta_key );
                    $meta_id        =           $wpdb->get_var( $mysql_query);
               
                    if (  $meta_id  >   0 )
                        {                            
                            //check if the meta entry exists
                            $mysql_query    =   $wpdb->prepare( "SELECT meta_value FROM " . $wpdb->postmeta ."
                                                        WHERE post_id   =   %d  AND meta_key    =   %s", $object_id, $meta_key );
                            $meta_value        =           $wpdb->get_var( $mysql_query);
                        }
                        else
                        {
                            //check if the meta entry exists
                            $mysql_query    =   $wpdb->prepare("SELECT meta_value FROM " . $wpdb->postmeta ."
                                                        WHERE post_id   =   %d  AND meta_key    =   %s", $object_id, $_base_meta_key);
                            $meta_value        =           $wpdb->get_var( $mysql_query);  
                            
                        }
                        
                    return $meta_value;
                    
                }
            
            
            
            /**
            * Filter the request and hide specific products for domains
            * 
            * @param mixed $request
            * @param mixed $query
            * @return mixed
            */
            function posts_request( $request, $query )
                {
                    if ( ! $query->is_singular( )   ||  ! isset( $query->query_vars['post_type']) ||  $query->query_vars['post_type']   !=  'product'    )
                        return  $request;
                    
                    global $wpdb, $blog_id;
                    
                    $result =   $wpdb->get_row( $request );
                    
                    $meta_key_prefix    =   '';
                    if ( $blog_id > 1 )
                        $meta_key_prefix    =   '_' .   $wpdb->base_prefix  .   $blog_id;
                        
                    $visibility =   get_post_meta( $result->ID, $meta_key_prefix . '_womd_visibility', TRUE );
                    if  ( ! empty ( $visibility )   &&  $visibility ==  'hide' )
                        $request    .=  ' LIMIT 0';
                        
                    return $request;
                    
                }
                
                
            /**
            * Filter the queries and exclude specific products if apply
            * 
            * @param mixed $where
            * @param mixed $query
            */
            function posts_clauses( $pieces, $query )
                {
                    
                    if ( defined ( 'WOOMD_WHEN_PRODUCT_HIDED_DO_NOT_SHOW_ON_SHOP_DASHBOARD_TOO' )       &&      WOOMD_WHEN_PRODUCT_HIDED_DO_NOT_SHOW_ON_SHOP_DASHBOARD_TOO === FALSE     &&  is_admin() )
                        return $pieces;
                    
                    global $wpdb;
                    
                    if ( 
                               ! $query->is_search() 
                                && ! ( isset( $query->query_vars['post_type']) &&  $query->query_vars['post_type']   ==  'product')
                                
                                && $pieces['fields']    !=  $wpdb->posts . '.*'
                                )
                                return $pieces;
                    
                    global $wpdb;
                                
                    $exclude_products   =   wp_cache_get( 'exclude_products', 'woomd' );
                    if  ( $exclude_products === FALSE ) 
                        {
                            $exclude_products   =   $this->get_excluded_product();
                            wp_cache_set( 'exclude_products', $exclude_products,  'woomd' );
                        }
                    
                    if  ( is_array($exclude_products)   &&  count ( $exclude_products ) > 0 ) 
                        $pieces['where']    .=  ' AND ' .$wpdb->posts . '.ID NOT IN (' .  implode( ",", $exclude_products ) .')';
                    
                    return $pieces;
                        
                }
                
                
            
            
            /**
            * Return excluded products from current domain
            * 
            */
            function get_excluded_product()
                {
                    
                    global $wpdb, $blog_id;
                    
                    $meta_key_prefix    =   '';
                    if ( $blog_id > 1 )
                        $meta_key_prefix    =   '_' .   $wpdb->base_prefix  .   $blog_id;
                    
                    $mysql_query    =   "SELECT ID FROM " . $wpdb->posts . " AS P
                                                JOIN " . $wpdb->postmeta . " AS PM ON PM.post_id    =   P.ID
                                                WHERE P.post_type   =   'product'   AND PM.meta_key =   '". $meta_key_prefix . "_womd_visibility'   AND PM.meta_value   =   'hide'";
                    $results                    =   $wpdb->get_results (  $mysql_query );
                    
                    $exclude_posts  =   array();
                    
                    foreach ( $results  as  $result ) 
                        {
                            $exclude_posts[]    =   $result->ID;     
                        }
                        
                    return $exclude_posts;                    
                    
                }
                
                
            
            function woocommerce_new_order( $order_id, $order )
                {
                    
                    global $blog_id;
                    
                    update_post_meta( $order_id, '_checkout_domain_id', $blog_id );    
                    
                }
                
        }


    new Woo_MultiDomain_general_filters();
        
?>