<?php

    class Woo_MultiDomain 
        {
            
            public  $functions;
            public  $licence;
            
            public  $woomd_network;
                      
            
            public $admin_notices  =   array();
            
            /**
            * Constructor
            * 
            */
            function __construct()
                {
                    
                    $this->functions        =   new Woo_MultiDomain_Functions();   
                    $this->licence          =   new Woo_MultiDomain_licence();
                    
                    $this->woomd_network    =   $this->functions->network; 
                    
                }
                
                
            
            /**
            * Starter
            * 
            */
            function init()
                {
                    
                    $options    =   $this->functions->get_options();
                    
                    $this->functions->check_wp_config();
                    $this->functions->check_mu_loader();
                    
                    if( is_admin() )
                        {
                            //include internal update procedures on update
                            include_once( WOOMULTID_PATH . 'includes/class.on-update.php');
                        }
                    
                    
                    //Domains interface init
                    add_action( 'init',                                     array( $this, 'interfaces_init' ) );
                    add_action( 'admin_notices',                            array( $this, 'admin_notices' ));
                    
                    if ( ! $this->woomd_network->is_current_domain_setup() )
                        {
                            $this->admin_notices[]  =   array ( 
                                                                'type'      =>  'error',
                                                                'message'   =>  __( 'The current domain has not been included in the ', 'woo-multidomain' ) . '<a href="'. admin_url('admin.php?page=woo-multidomain') .'">WooCommerce MultiDomain network.</a>'
                                                                );
                               
                            return FALSE;
                        }
                    
                    if( $options['cart_checkout_type']  ==  'each_store' )
                        include_once ( WOOMULTID_PATH . '/includes/cart-split/class.woomd.cart-split-core.php');
                     
                    include_once( WOOMULTID_PATH . '/includes/class.general-filters.php' );
                    
                    include_once ( WOOMULTID_PATH . '/includes/class.compatibility.php');
                    
                    
                    if ( $this->is_request( 'admin' ) )
                            $this->admin_includes();
                    
                    if ( $this->is_request( 'frontend' ) )
                            $this->frontend_includes();
                            
                    add_action( 'plugins_loaded',                           array( $this, 'on_plugins_loaded') );                            
                    
                    add_filter( 'woocommerce_init',                         array($this, 'woocommerce_init'));
                    
                    //add the admin menus
                    add_action( 'admin_bar_menu',                           array( $this, 'admin_bar_menu_init' ), 15 );
                    
                    
                    //AJAX inits
                    add_action( 'init',                                     array( $this, 'ajax_init' ) );
                                        
                    //WooCommerce Product interface
                    //WooCommerce Orders interface
                    add_action('load-post.php',                             array($this, 'woo_product_interface_init'));
                    add_action('load-post-new.php',                         array($this, 'woo_product_interface_init'));
                    
                    //Data Store replacements
                    add_filter( 'woocommerce_data_stores',                  array($this, 'woocommerce_data_stores'), 999);       
                    
                    add_filter( 'woocommerce_session_handler',              array( $this, 'woocommerce_session_handler' ), 999 );
                    
                    
                    add_action( 'wp_footer',                            array( $this, 'on_action_wp_footer') );
                    add_action( 'admin_footer',                         array( $this, 'on_action_wp_footer') );
                    add_action( 'login_footer',                         array( $this, 'on_action_wp_footer') );
                    
                    //after item add to cart through AJAX make sure other blogs know about the session id
                    add_action( 'woocommerce_add_to_cart_fragments',    array( $this, 'on_action_woocommerce_add_to_cart_fragments'));   
                        
                    add_action( 'shutdown',                             array( $this, 'on__shutdown'), 1 );
                    
                }
                
            
            function woocommerce_init()
                {
                    
                    include_once ( WOOMULTID_PATH . '/includes/class.cart-session.php');
                    if(! is_null($GLOBALS['woocommerce']->cart))
                        {
                            $GLOBALS['woocommerce']->cart->session   =   new Woo_MultiDomain_Cart_Session( $GLOBALS['woocommerce']->cart );
                        }
                        
                    //replace the default checkout with an extended WC_Checkout instance
                    include_once ( WOOMULTID_PATH . '/includes/checkout/class.wc-checkout-extend.php');
                    add_action( 'woocommerce_checkout_init',            array( 'WOOMD_WC_Checkout', 'instance' ), 999 );
                    
                }
            
            
            function admin_includes()
                {
                    include_once( WOOMULTID_PATH . '/includes/class.general-filters-admin.php' );
                }
            
            function frontend_includes()
                {
                    include_once( WOOMULTID_PATH . '/includes/class.cart.php' );                    
                    include_once( WOOMULTID_PATH . '/includes/class.general-filters-frontend.php' );
                    include_once( WOOMULTID_PATH . '/includes/order/class.order.php' );
                                                                                          
                    include_once( WOOMULTID_PATH . '/includes/class.template.php' );
                }
            
                
            /**
            * Returns true if the request is a non-legacy REST API request.
            *
            * Legacy REST requests should still run some extra code for backwards compatibility.
            *
            * @todo: replace this function once core WP function is available: https://core.trac.wordpress.org/ticket/42061.
            *
            * @return bool
            */
            public function is_rest_api_request() 
                {
                    if ( empty( $_SERVER['REQUEST_URI'] ) ) 
                        {
                            return false;
                        }

                    $rest_prefix         = trailingslashit( rest_get_url_prefix() );
                    $is_rest_api_request = ( false !== strpos( $_SERVER['REQUEST_URI'], $rest_prefix ) );

                    return apply_filters( 'woocommerce_is_rest_api_request', $is_rest_api_request );
                }
                

            /**
            * What type of request is this?
            *
            * @param  string $type admin, ajax, cron or frontend.
            * @return bool
            */
            private function is_request( $type ) 
                {
                    switch ( $type ) 
                        {
                            case 'admin':
                                            return is_admin();
                            case 'ajax':
                                            return defined( 'DOING_AJAX' );
                            case 'cron':
                                            return defined( 'DOING_CRON' );
                            case 'frontend':
                                            return ( ! is_admin() || defined( 'DOING_AJAX' ) ) && ! defined( 'DOING_CRON' ) && ! $this->is_rest_api_request();
                        }
                }

                
            
            /**
            * Create the additional admin menu bar
            * 
            * @param mixed $wp_admin_bar
            */
            function admin_bar_menu_init( $wp_admin_bar )
                {
                    
                    include_once( WOOMULTID_PATH . '/includes/admin/admin-bar.php' );   
                    woomd_admin_bar_my_domains_menu( $wp_admin_bar );
                    
                } 
                   
                
            /**
            * Define the menus
            * 
            */
            function interfaces_init()
                {
                    
                    if ( is_admin() )
                        {
                            include_once( WOOMULTID_PATH . '/includes/class.admin-interface.php' );
                            $this->admin_interface    =    new Woo_MultiDomain_interface();                                  
                        }
                    
                }
            
            
            
            /**
            * AJAX loaders
            * 
            */
            function ajax_init()
                {
                    include_once( WOOMULTID_PATH . '/includes/class.ajax.php' );
                    $ajax       =    new Woo_MultiDomain_ajax();                       
                }
                
               
                
            function woo_product_interface_init()
                {
                    
                    global $pagenow;
                    
                    $current_screen             =   get_current_screen();
                     
                    //add product fields
                    if(is_object($current_screen)   &&  $current_screen->post_type  ==  'product')
                        {
                            include_once( WOOMULTID_PATH . '/includes/class.admin.product-interface.php' );
                            new Woo_MultiDomain_product_interface();
                        }
                    
                }
                
            
            /**
            * Include the custom stores
            * 
            * @param mixed $stores
            */
            function woocommerce_data_stores( $stores )
                {
                    include_once( WOOMULTID_PATH . '/includes/data-stores/class-woomd-product-data-store-cpt.php' );   
                    include_once( WOOMULTID_PATH . '/includes/data-stores/class-woomd-product-variable-data-store-cpt.php' );   
                    include_once( WOOMULTID_PATH . '/includes/data-stores/class-woomd-product-variation-data-store-cpt.php' );   
                    
                    $stores['product']              =   'WooMD_Product_Data_Store_CPT';
                    $stores['product-variable']     =   'WooMD_Product_Variable_Data_Store_CPT';
                    $stores['product-variation']    =   'WooMD_Product_Variation_Data_Store_CPT';
                                        
                    return $stores; 
                }
                
                
            function woocommerce_session_handler()
                {
                    
                    include_once( WOOMULTID_PATH . '/includes/class.woomd.wc-session-handler.php');
                    
                    return 'WooMD_WC_Session_Handler';    
                    
                }
            
            
            function on_plugins_loaded()
                {
                    
                    //Allow each domain to use it's own content
                    //Save the content for each domain
                    if  ( defined( 'WOOMD_ALLOW_PRODUCT_DIFFERENT_CONTENT_ON_DOMAINS' ) &&    WOOMD_ALLOW_PRODUCT_DIFFERENT_CONTENT_ON_DOMAINS ===  TRUE )
                        include_once ( WOOMULTID_PATH . '/includes/class.product-content.php');
                        
                    
                    if  ( defined( 'WOOMD_EACH_DOMAIN_CONTENT' ) &&    WOOMD_EACH_DOMAIN_CONTENT ===  TRUE )
                        include_once ( WOOMULTID_PATH . '/includes/class.general-content.php');
                    
                    //turn on buffering
                    ob_start( array( $this, 'ob_start_process') );
                    
                    //Relocate default WordPress shutdown hook
                    remove_action(  'shutdown',                   'wp_ob_end_flush_all',                      1    );
                    add_action(     'shutdown',                   'wp_ob_end_flush_all',                      2    );
                        
                }
            
                
            /**
            * On WordPress shutdown
            * Change any checkout links to plugin option
            * 
            */
            function on__shutdown()
                {
                    global $blog_id, $woocommerce;
                    
                    if(!is_object($woocommerce->cart))
                        return;
                       
                    $options        =   $this->functions->get_options();
                    $blog_details   =   $this->woomd_network->get_domain( $blog_id );
         
                    $levels = ob_get_level();
                    
                    if( $levels < 1 )
                        return; 
                    
                    for ( $i = 2; $i < $levels; $i++ )
                        {
                            
                            $flush_level   =   TRUE;
                            if  ( $i == ( $levels - 1 ) ) 
                                $flush_level   =   FALSE;
                              
                            //allow other ob handlers to force a break
                            $continue   =   apply_filters('woomd/on_shutdown/ob_buferring_output', TRUE, ob_get_status() );
                            if (  $continue !== TRUE )
                                return;
                            
                            if  ( $flush_level  === TRUE )
                                {
                                    ob_get_flush();
                                    continue;
                                }
                            
                            $thml   =   ob_get_clean();
                            //ob_end_clean();
                            
                            //replace any checkout links
                            if( $options['cart_checkout_type']  ==  'single_checkout'  &&  !   empty($options['cart_checkout_location'])   &&  $options['cart_checkout_location']  !=  $blog_id)
                                {
                                    $checkout_url   =   wc_get_checkout_url();
                                    $checkout_url   =   str_replace(array('http:', 'https:'), "", $checkout_url);
                                    $checkout_url   =   trailingslashit($checkout_url);
                                    
                                    $thml   =   str_replace( "//"   .   $blog_details->domain .  untrailingslashit($blog_details->path) . "/checkout/", $checkout_url, $thml);
                                
                                }
                                else if ( $options['cart_checkout_type']  ==  'each_store'  &&  isset ( $woocommerce->cart->cart_split ) )
                                        {
                                            $checkout_url   =   $woocommerce->cart->cart_split->get_checkout_url();
                                            $checkout_url   =   str_replace(array('http:', 'https:'), "", $checkout_url);
                                            $checkout_url   =   trailingslashit($checkout_url);
                                            
                                            $thml   =   str_replace( "//"   .   $blog_details->domain .  untrailingslashit($blog_details->path) . "/checkout/", $checkout_url, $thml);
                                        }
                            
                            echo $thml;
                            
                        }
                    
                }
                
                
                
            function admin_notices ( )
                {
                    
                    if( ! $this->functions->is_muloader())
                        {
                            $this->admin_notices[]  =   array ( 
                                                                'type'      =>  'error',
                                                                'message'   =>  __( 'Unable to launch WP Hide through mu-plugins/wp-hide-loader.php<br /> Please make sure this location is writable so the plugin create the required file, or manually copy the wp-hide-security-enhancer-pro/mu-loader/wp-hide-loader.php to mu-plugins/wp-hide-loader.php.', 'woo-multidomain' )
                                                                ); 
                        }
                        
                    if( ! $this->functions->check_wp_config( FALSE ))
                        {
                            $this->admin_notices[]  =   array ( 
                                                                'type'      =>  'error',
                                                                'message'   =>  __( 'Unable to add required data to wp-config.php<br /> Please make sure this location is writable so the plugin append required data.', 'woo-multidomain' )
                                                                ); 
                        }
                    
                    
                    if ( count ( $this->admin_notices )  < 1 )
                        return;
                        
                    foreach ( $this->admin_notices as    $notice )
                        {
                            echo "<div class='". $notice['type'] ."'><p>". $notice['message']  ."</p></div>";
                        }
                
                }
            
            
            
            
            function on_action_woocommerce_add_to_cart_fragments( $mini_cart )
                {
                    return $mini_cart;
                    
                    //only when doing AJAX
                    if ( ! defined( 'DOING_AJAX' ) )
                        return $mini_cart;
                    
                    ob_start(); 
                    ?>
                    <script type='text/javascript'> WooMD_Sync.init(); </script>
                    <?php
                    $html   =   ob_get_contents();
                    ob_end_clean();
                    
                    $mini_cart['div.widget_shopping_cart_content'] .=   $html;
                    
                    return $mini_cart;
                       
                }
                
                
                
            /**
            * Trigger on WordPress wp_footer action
            * Output front side JavaScript code for syncronisation
            * 
            */
            function on_action_wp_footer()
                {
                    
                    //clear expired triggers
                    $this->clear_expired_triggers();
                        
                    if ( ! $this->functions->is_plugin_active( 'woocommerce/woocommerce.php') )
                        return;
                    
                    global $blog_id;
                                       
                    $sync_directory     =   WOOMULTID_URL   .   '/sync';
                       
                    $site_home  =   site_url();
                    $site_home  =   str_replace(array('http://', 'https://'), "", $site_home);
                    $site_home  =   trim($site_home, '/');
                      
                    $sync_directory_url     =   str_replace(array('http://', 'https://'), "", $sync_directory);
                    $sync_directory_url     =   str_replace($site_home, "", $sync_directory_url);
                    $sync_directory_url     =   apply_filters( 'woomd/sync_directory_url', $sync_directory_url );
                    
                    ?>
                    
                    
                    <div id="woomd_sync_wrapper" style="display: none"></div>
                    <script type='text/javascript'>
                    /* <![CDATA[ */
                    var WooMD_Sync_Url      =    '<?php echo $sync_directory_url ?>';
                    var WooMD_Sites = [<?php
                                                    
                            $first  =   TRUE;
                                                    
                            $processed_domains  =   array();
                            $blog_details   =   $this->woomd_network->get_domain( $blog_id );
                            
                            //ignore current domain
                            $processed_domains[]    =   WooMD_get_domain( $blog_details->domain );
                            
                            $options    =   $this->functions->get_options();
                            
                            $sites      =   $this->woomd_network->get_domains( TRUE );
                            $sites      =   $sites['items'];
                            
                            $sites_ids  =   array();
                            foreach($sites  as  $site)
                                {
                                    if ( isset ( $options['use_global_cart_for_sites'][ $site['id'] ] )    &&  $options['use_global_cart_for_sites'][ $site['id'] ] == 'no' )
                                        continue;
                                        
                                    //check if the globalcart is disabled for site
                                    if ( apply_filters( 'woomd/disable_global_cart',     FALSE,  $site['id'] ) === FALSE )
                                        $sites_ids[]    =   $site['id'];   
                                }
                            
                            $allowed_gc_sites   =   apply_filters('woomd/global_cart/sites', $sites_ids);

                            $disabled_gc_sites  =   array();

                            foreach( $sites  as  $site )
                                {
                                    
                                    //ignore the current site
                                    if( $site['id']   ==  $blog_id )
                                        {
                                            if  ( !in_array($blog_id, $allowed_gc_sites)) 
                                                {   
                                                    $disabled_gc_sites[]    =   $site['id'] ;   
                                                }
                                            continue;
                                        }
                                        
                                    //no need to set for subfolder domains
                                    if($site['path']  !=  '/')
                                        continue;
                                        
                                    $domain_root    =   WooMD_get_domain( $site['domain'] );
                                                          
                                    //if domain already processed continue
                                    if( in_array( $domain_root, $processed_domains ) )
                                        continue;
                                    
                                    $processed_domains[]    =   $domain_root;
                                    
                                    if  ( in_array( $site['id'], $allowed_gc_sites)) 
                                        {
                                            if ( !$first )
                                                echo ', ';
                                            echo "'//" . $site['domain'] . "'";

                                            $first  =   FALSE;
                                        }
                                        else
                                        {
                                            $disabled_gc_sites[]    =   $site['id'] ;   
                                        }
                                }
                              
                        ?>];
                     <?php            
  
                        //output JavaScript variable for POST action to catch on specific methods
                        $WooMD_on_PostVars  =   apply_filters('woomd/sync/on_post_vars', array());
                        if(is_array($WooMD_on_PostVars) &&  count($WooMD_on_PostVars) > 0)
                            {
                                ?>
                                var WooMD_on_PostVars   =   [<?php  
                                    
                                    $first = TRUE;
                                    foreach ($WooMD_on_PostVars as $key =>  $value)
                                        {
                                            if($first === TRUE)
                                                $first  =   FALSE;
                                                else
                                                echo ", ";
                                                
                                            echo '"' . $value . '"';    
                                        }
                                
                                 ?>];
                                <?php
                            }
                            else
                            {
                                ?>
                                var WooMD_on_PostVars   =   [];
                                <?php   
                            }
                            
                    ?>
                    /* ]]> */
                    </script>
                    <script type='text/javascript' src='<?php echo str_replace(array('http:', 'https:'), "", WOOMULTID_URL) ?>/assets/js/woomd-sync.js?ver=1.1'></script>
    
                    <?php                    
                     
      
                }
                
                
            function clear_expired_triggers()
                {
                    
                    global $wpdb;
                    
                    $mysql_query    =   "UPDATE "  .   $wpdb->base_prefix . 'woocommerce_woomd_sessions' . " 
                                                SET trigger_key =   '', trigger_key_expiry = '', trigger_user_hash = ''
                                                WHERE " . time() . " > trigger_key_expiry";
                    $wpdb->get_results( $mysql_query );
                }
                
            
            /**
            * Process the buffer
            * 
            */
            function ob_start_process( $buffer )
                {
                    if ( is_admin() )   
                        return $buffer;
                        
                    if ( strlen ( $buffer ) < 1 )
                        return $buffer;
                        
                    $options    =   $this->functions->get_options();
                    if ( $options['load_all_dependencies_through_local_domain'] != 'yes' )
                        return $buffer;
                        
                    global $blog_id;
                    
                    $current_domain =   $this->woomd_network->get_domain( $blog_id );
                    
                    $sites      =   $this->woomd_network->get_domains( );
                    $sites      =   $sites['items'];
                    
                    $domains   =   array();
                    
                    foreach ( $sites    as $site)
                        {
                            if ( $site['id']    ==  $blog_id )
                                continue;
                            
                            $domains[]      =   preg_quote ( untrailingslashit ( $site['domain'] ) );
                        }
                
                    $regex  =   '/(<script|<link)([^>]*)(' . implode( '|', $domains )  . ')(\/wp-)/m';
                                
                    $result = preg_replace( $regex, '$1$2' . $current_domain->domain . '$4', $buffer);
                    
                    if ( is_string( $result )   &&  strlen ( $result ) > 0 )
                        return $result;
                
                    return $buffer;
                
                }     
             
        }


?>