<?php

    if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

    /**
     * WC Product Data Store: Stored in CPT.
     *
     * @version  3.0.0
     */
    class WooMD_Product_Data_Store_CPT extends WC_Product_Data_Store_CPT 
        {

	        /**
	         * Read product data. Can be overridden by child classes to load other props.
	         *
	         * @param WC_Product $product Product object.
	         * @since 3.0.0
	         */
	        protected function read_product_data( &$product ) {
		        $id             = $product->get_id();
		        $review_count   = get_post_meta( $id, '_wc_review_count', true );
		        $rating_counts  = get_post_meta( $id, '_wc_rating_count', true );
		        $average_rating = get_post_meta( $id, '_wc_average_rating', true );

		        if ( '' === $review_count ) {
			        WC_Comments::get_review_count_for_product( $product );
		        } else {
			        $product->set_review_count( $review_count );
		        }

		        if ( '' === $rating_counts ) {
			        WC_Comments::get_rating_counts_for_product( $product );
		        } else {
			        $product->set_rating_counts( $rating_counts );
		        }

		        if ( '' === $average_rating ) {
			        WC_Comments::get_average_rating_for_product( $product );
		        } else {
			        $product->set_average_rating( $average_rating );
		        }

                global $wpdb, $blog_id;
                
                $meta_key_prefix    =   '';
                if ( $blog_id > 1 )
                    $meta_key_prefix    =   '_' .   $wpdb->base_prefix  .   $blog_id;
                    
                //ensure the entird exists oterwise create
                $this->check_if_fields_exists( $id );
                
		        $product->set_props(
			        array(
				        'sku'                => get_post_meta( $id, '_sku', true ),
				        'regular_price'      => get_post_meta( $id, $meta_key_prefix    .   '_regular_price', true ),
				        'sale_price'         => get_post_meta( $id, $meta_key_prefix    .   '_sale_price', true ),
				        'price'              => get_post_meta( $id, $meta_key_prefix    .   '_price', true ),
				        'date_on_sale_from'  => get_post_meta( $id, '_sale_price_dates_from', true ),
				        'date_on_sale_to'    => get_post_meta( $id, '_sale_price_dates_to', true ),
				        'total_sales'        => get_post_meta( $id, 'total_sales', true ),
				        'tax_status'         => get_post_meta( $id, '_tax_status', true ),
				        'tax_class'          => get_post_meta( $id, '_tax_class', true ),
				        'manage_stock'       => get_post_meta( $id, '_manage_stock', true ),
				        'stock_quantity'     => get_post_meta( $id, '_stock', true ),
				        'stock_status'       => get_post_meta( $id, '_stock_status', true ),
				        'backorders'         => get_post_meta( $id, '_backorders', true ),
				        'low_stock_amount'   => get_post_meta( $id, '_low_stock_amount', true ),
				        'sold_individually'  => get_post_meta( $id, '_sold_individually', true ),
				        'weight'             => get_post_meta( $id, '_weight', true ),
				        'length'             => get_post_meta( $id, '_length', true ),
				        'width'              => get_post_meta( $id, '_width', true ),
				        'height'             => get_post_meta( $id, '_height', true ),
				        'upsell_ids'         => get_post_meta( $id, '_upsell_ids', true ),
				        'cross_sell_ids'     => get_post_meta( $id, '_crosssell_ids', true ),
				        'purchase_note'      => get_post_meta( $id, '_purchase_note', true ),
				        'default_attributes' => get_post_meta( $id, '_default_attributes', true ),
				        'category_ids'       => $this->get_term_ids( $product, 'product_cat' ),
				        'tag_ids'            => $this->get_term_ids( $product, 'product_tag' ),
				        'shipping_class_id'  => current( $this->get_term_ids( $product, 'product_shipping_class' ) ),
				        'virtual'            => get_post_meta( $id, '_virtual', true ),
				        'downloadable'       => get_post_meta( $id, '_downloadable', true ),
				        'gallery_image_ids'  => array_filter( explode( ',', get_post_meta( $id, '_product_image_gallery', true ) ) ),
				        'download_limit'     => get_post_meta( $id, '_download_limit', true ),
				        'download_expiry'    => get_post_meta( $id, '_download_expiry', true ),
				        'image_id'           => get_post_thumbnail_id( $id ),
			        )
		        );
                
		        // Handle sale dates on the fly in case of missed cron schedule.
		        if ( $blog_id  < 2 && ( $product->is_type( 'simple' )   ||  $product->is_type( 'external' ) ) && $product->is_on_sale( 'edit' ) && $product->get_sale_price( 'edit' ) !== $product->get_price( 'edit' ) ) 
                        {
			                update_post_meta( $product->get_id(), '_price', $product->get_sale_price( 'edit' ) );
			                $product->set_price( $product->get_sale_price( 'edit' ) );
		                }
                    else if ( ( $product->is_type( 'simple' )   ||  $product->is_type( 'external' ) ) && $product->is_on_sale( 'edit' ) && $product->get_sale_price( 'edit' ) !== $product->get_price( 'edit' ) )
                        {
                            $meta_key_name    =   '_' .   $wpdb->base_prefix  .   $blog_id    .  '_price';
                            update_post_meta( $product->get_id(), $meta_key_name, $product->get_sale_price( 'edit' ) );
                            $product->set_price( $product->get_sale_price( 'edit' ) );   
                        }
	        }
            
            
            /**
             * Helper method that updates all the post meta for a product based on it's settings in the WC_Product class.
             *
             * @param WC_Product $product Product object.
             * @param bool       $force Force update. Used during create.
             * @since 3.0.0
             */
            protected function update_post_meta( &$product, $force = false ) {
                
                global $wpdb, $blog_id;
                
                $meta_key_to_props = array(
                    '_sku'                   => 'sku',
                    '_regular_price'         => 'regular_price',
                    '_sale_price'            => 'sale_price',
                    '_sale_price_dates_from' => 'date_on_sale_from',
                    '_sale_price_dates_to'   => 'date_on_sale_to',
                    'total_sales'            => 'total_sales',
                    '_tax_status'            => 'tax_status',
                    '_tax_class'             => 'tax_class',
                    '_manage_stock'          => 'manage_stock',
                    '_backorders'            => 'backorders',
                    '_low_stock_amount'      => 'low_stock_amount',
                    '_sold_individually'     => 'sold_individually',
                    '_weight'                => 'weight',
                    '_length'                => 'length',
                    '_width'                 => 'width',
                    '_height'                => 'height',
                    '_upsell_ids'            => 'upsell_ids',
                    '_crosssell_ids'         => 'cross_sell_ids',
                    '_purchase_note'         => 'purchase_note',
                    '_default_attributes'    => 'default_attributes',
                    '_virtual'               => 'virtual',
                    '_downloadable'          => 'downloadable',
                    '_product_image_gallery' => 'gallery_image_ids',
                    '_download_limit'        => 'download_limit',
                    '_download_expiry'       => 'download_expiry',
                    '_thumbnail_id'          => 'image_id',
                    '_stock'                 => 'stock_quantity',
                    '_stock_status'          => 'stock_status',
                    '_wc_average_rating'     => 'average_rating',
                    '_wc_rating_count'       => 'rating_counts',
                    '_wc_review_count'       => 'review_count',
                );

                // Make sure to take extra data (like product url or text for external products) into account.
                $extra_data_keys = $product->get_extra_data_keys();

                foreach ( $extra_data_keys as $key ) {
                    $meta_key_to_props[ '_' . $key ] = $key;
                }

                $props_to_update = $force ? $meta_key_to_props : $this->get_props_to_update( $product, $meta_key_to_props );

                foreach ( $props_to_update as $meta_key => $prop ) {
                    $value = $product->{"get_$prop"}( 'edit' );
                    $value = is_string( $value ) ? wp_slash( $value ) : $value;
                    switch ( $prop ) {
                        case 'virtual':
                        case 'downloadable':
                        case 'manage_stock':
                        case 'sold_individually':
                            $updated = update_post_meta( $product->get_id(), $meta_key, wc_bool_to_string( $value ) );
                            break;
                        case 'gallery_image_ids':
                            $updated = update_post_meta( $product->get_id(), $meta_key, implode( ',', $value ) );
                            break;
                        case 'image_id':
                            if ( ! empty( $value ) ) {
                                set_post_thumbnail( $product->get_id(), $value );
                            } else {
                                delete_post_meta( $product->get_id(), '_thumbnail_id' );
                            }
                            $updated = true;
                            break;
                        case 'date_on_sale_from':
                        case 'date_on_sale_to':
                            $updated = update_post_meta( $product->get_id(), $meta_key, $value ? $value->getTimestamp() : '' );
                            break;
                        case 'regular_price':
                        case 'sale_price':
                            
                            if ( $blog_id > 1 )
                                $meta_key    =   '_' .   $wpdb->base_prefix  .   $blog_id    .  $meta_key;   
                            
                            $updated = update_post_meta( $product->get_id(), $meta_key, $value );
                                                    
                            break;
                        default:
                            $updated = update_post_meta( $product->get_id(), $meta_key, $value );
                            break;
                    }
                    if ( $updated ) {
                        $this->updated_props[] = $prop;
                    }
                }

                // Update extra data associated with the product like button text or product URL for external products.
                if ( ! $this->extra_data_saved ) {
                    foreach ( $extra_data_keys as $key ) {
                        if ( ! array_key_exists( '_' . $key, $props_to_update ) ) {
                            continue;
                        }
                        $function = 'get_' . $key;
                        if ( is_callable( array( $product, $function ) ) ) {
                            $value = $product->{$function}( 'edit' );
                            $value = is_string( $value ) ? wp_slash( $value ) : $value;

                            if ( update_post_meta( $product->get_id(), '_' . $key, $value ) ) {
                                $this->updated_props[] = $key;
                            }
                        }
                    }
                }

                if ( $this->update_downloads( $product, $force ) ) {
                    $this->updated_props[] = 'downloads';
                }
            }
            
            
            
            /**
             * Handle updated meta props after updating meta data.
             *
             * @since 3.0.0
             * @param WC_Product $product Product Object.
             */
            protected function handle_updated_props( &$product ) {
                $price_is_synced = $product->is_type( array( 'variable', 'grouped' ) );

                if ( ! $price_is_synced ) {
                    
                    global $wpdb, $blog_id;
                    
                    $meta_key_prefix    =   '';
                    if ( $blog_id > 1 )
                        $meta_key_prefix    =   '_' .   $wpdb->base_prefix  .   $blog_id;
                    
                    if ( in_array( 'regular_price', $this->updated_props, true ) || in_array( 'sale_price', $this->updated_props, true ) ) {
                        if ( $product->get_sale_price( 'edit' ) >= $product->get_regular_price( 'edit' ) ) {
                            update_post_meta( $product->get_id(), $meta_key_prefix . '_sale_price', '' );
                            $product->set_sale_price( '' );
                        }
                    }

                    if ( in_array( 'date_on_sale_from', $this->updated_props, true ) || in_array( 'date_on_sale_to', $this->updated_props, true ) || in_array( 'regular_price', $this->updated_props, true ) || in_array( 'sale_price', $this->updated_props, true ) || in_array( 'product_type', $this->updated_props, true ) ) {
                        if ( $product->is_on_sale( 'edit' ) ) {
                            update_post_meta( $product->get_id(), $meta_key_prefix . '_price', $product->get_sale_price( 'edit' ) );
                            $product->set_price( $product->get_sale_price( 'edit' ) );
                        } else {
                            update_post_meta( $product->get_id(), $meta_key_prefix . '_price', $product->get_regular_price( 'edit' ) );
                            $product->set_price( $product->get_regular_price( 'edit' ) );
                        }
                    }
                }

                if ( in_array( 'stock_quantity', $this->updated_props, true ) ) {
                    if ( $product->is_type( 'variation' ) ) {
                        do_action( 'woocommerce_variation_set_stock', $product );
                    } else {
                        do_action( 'woocommerce_product_set_stock', $product );
                    }
                }

                if ( in_array( 'stock_status', $this->updated_props, true ) ) {
                    if ( $product->is_type( 'variation' ) ) {
                        do_action( 'woocommerce_variation_set_stock_status', $product->get_id(), $product->get_stock_status(), $product );
                    } else {
                        do_action( 'woocommerce_product_set_stock_status', $product->get_id(), $product->get_stock_status(), $product );
                    }
                }

                // Trigger action so 3rd parties can deal with updated props.
                do_action( 'woocommerce_product_object_updated_props', $product, $this->updated_props );

                // After handling, we can reset the props array.
                $this->updated_props = array();
            }
            
            
            protected function check_if_fields_exists( $object_id )
                {
                    
                    global $wpdb, $blog_id;
                    
                    //no need to run for main shop
                    if  ( $blog_id < 2 )
                        return;
                         
                    $_meta_keys  =   array(
                                                    '_regular_price',
                                                    '_sale_price',
                                                    '_price'
                                                    );    
                    
                    foreach ( $_meta_keys   as  $_meta_key )
                        {
                            
                            $_object_meta_key         =   '_' .   $wpdb->base_prefix  .   $blog_id .  $_meta_key;
                                
                            $mysql_query    =   $wpdb->prepare( "SELECT meta_id FROM " . $wpdb->postmeta ."
                                                                WHERE post_id   =   %d  AND meta_key    =   %s", $object_id, $_object_meta_key );
                            $meta_value        =           $wpdb->get_var( $mysql_query);

                            if (  $meta_value   === null )
                                {                            
                                    //check if the meta entry exists
                                    $mysql_query    =   $wpdb->prepare("SELECT meta_value FROM " . $wpdb->postmeta ."
                                                                WHERE post_id   =   %d  AND meta_key    =   %s", $object_id, $_meta_key );
                                    $meta_value     =   $wpdb->get_var( $mysql_query);
                                    
                                    $mysql_query    =   $wpdb->prepare("INSERT INTO " . $wpdb->postmeta ." 
                                                                (`meta_id`, `post_id`, `meta_key`, `meta_value`) VALUES (NULL, %d, %s, %s);", $object_id, $_object_meta_key, $meta_value);
                                    $result         =   $wpdb->get_results( $mysql_query);
                                }   
                            
                            
                        }
                    
                }
          
        }
        
        
?>