<?php


    if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

    /**
     * WC Variation Product Data Store: Stored in CPT.
     *
     * @version  3.0.0
     */
    class WooMD_Product_Variation_Data_Store_CPT extends WC_Product_Variation_Data_Store_CPT
        {
            
            /**
             * Read post data.
             *
             * @since 3.0.0
             * @param WC_Product $product Product object.
             * @throws WC_Data_Exception If WC_Product::set_tax_status() is called with an invalid tax status.
             */
            protected function read_product_data( &$product ) 
                {
                    $id = $product->get_id();
                    
                    global $wpdb, $blog_id;
                
                    $meta_key_prefix    =   '';
                    if ( $blog_id > 1 )
                        $meta_key_prefix    =   '_' .   $wpdb->base_prefix  .   $blog_id;
                        
                    //ensure the entird exists oterwise create
                    $this->check_if_fields_exists( $id );

                    $product->set_props(
                        array(
                            'description'       => get_post_meta( $id, '_variation_description', true ),
                            'regular_price'     => get_post_meta( $id, $meta_key_prefix    .   '_regular_price', true ),
                            'sale_price'        => get_post_meta( $id, $meta_key_prefix    .   '_sale_price', true ),
                            'date_on_sale_from' => get_post_meta( $id, '_sale_price_dates_from', true ),
                            'date_on_sale_to'   => get_post_meta( $id, '_sale_price_dates_to', true ),
                            'manage_stock'      => get_post_meta( $id, '_manage_stock', true ),
                            'stock_status'      => get_post_meta( $id, '_stock_status', true ),
                            'shipping_class_id' => current( $this->get_term_ids( $id, 'product_shipping_class' ) ),
                            'virtual'           => get_post_meta( $id, '_virtual', true ),
                            'downloadable'      => get_post_meta( $id, '_downloadable', true ),
                            'gallery_image_ids' => array_filter( explode( ',', get_post_meta( $id, '_product_image_gallery', true ) ) ),
                            'download_limit'    => get_post_meta( $id, '_download_limit', true ),
                            'download_expiry'   => get_post_meta( $id, '_download_expiry', true ),
                            'image_id'          => get_post_thumbnail_id( $id ),
                            'backorders'        => get_post_meta( $id, '_backorders', true ),
                            'sku'               => get_post_meta( $id, '_sku', true ),
                            'stock_quantity'    => get_post_meta( $id, '_stock', true ),
                            'weight'            => get_post_meta( $id, '_weight', true ),
                            'length'            => get_post_meta( $id, '_length', true ),
                            'width'             => get_post_meta( $id, '_width', true ),
                            'height'            => get_post_meta( $id, '_height', true ),
                            'tax_class'         => ! metadata_exists( 'post', $id, '_tax_class' ) ? 'parent' : get_post_meta( $id, '_tax_class', true ),
                        )
                    );

                    if ( $product->is_on_sale( 'edit' ) ) {
                        $product->set_price( $product->get_sale_price( 'edit' ) );
                    } else {
                        $product->set_price( $product->get_regular_price( 'edit' ) );
                    }

                    $parent_object   = get_post( $product->get_parent_id() );
                    $terms           = get_the_terms( $product->get_parent_id(), 'product_visibility' );
                    $term_names      = is_array( $terms ) ? wp_list_pluck( $terms, 'name' ) : array();
                    $exclude_search  = in_array( 'exclude-from-search', $term_names, true );
                    $exclude_catalog = in_array( 'exclude-from-catalog', $term_names, true );

                    if ( $exclude_search && $exclude_catalog ) {
                        $catalog_visibility = 'hidden';
                    } elseif ( $exclude_search ) {
                        $catalog_visibility = 'catalog';
                    } elseif ( $exclude_catalog ) {
                        $catalog_visibility = 'search';
                    } else {
                        $catalog_visibility = 'visible';
                    }

                    $product->set_parent_data(
                        array(
                            'title'              => $parent_object ? $parent_object->post_title : '',
                            'status'             => $parent_object ? $parent_object->post_status : '',
                            'sku'                => get_post_meta( $product->get_parent_id(), '_sku', true ),
                            'manage_stock'       => get_post_meta( $product->get_parent_id(), '_manage_stock', true ),
                            'backorders'         => get_post_meta( $product->get_parent_id(), '_backorders', true ),
                            'low_stock_amount'   => get_post_meta( $product->get_parent_id(), '_low_stock_amount', true ),
                            'stock_quantity'     => wc_stock_amount( get_post_meta( $product->get_parent_id(), '_stock', true ) ),
                            'weight'             => get_post_meta( $product->get_parent_id(), '_weight', true ),
                            'length'             => get_post_meta( $product->get_parent_id(), '_length', true ),
                            'width'              => get_post_meta( $product->get_parent_id(), '_width', true ),
                            'height'             => get_post_meta( $product->get_parent_id(), '_height', true ),
                            'tax_class'          => get_post_meta( $product->get_parent_id(), '_tax_class', true ),
                            'shipping_class_id'  => absint( current( $this->get_term_ids( $product->get_parent_id(), 'product_shipping_class' ) ) ),
                            'image_id'           => get_post_thumbnail_id( $product->get_parent_id() ),
                            'purchase_note'      => get_post_meta( $product->get_parent_id(), '_purchase_note', true ),
                            'catalog_visibility' => $catalog_visibility,
                        )
                    );

                    // Pull data from the parent when there is no user-facing way to set props.
                    $product->set_sold_individually( get_post_meta( $product->get_parent_id(), '_sold_individually', true ) );
                    $product->set_tax_status( get_post_meta( $product->get_parent_id(), '_tax_status', true ) );
                    $product->set_cross_sell_ids( get_post_meta( $product->get_parent_id(), '_crosssell_ids', true ) );
                }
                
                
                
            
            /**
             * Helper method that updates all the post meta for a product based on it's settings in the WC_Product class.
             *
             * @param WC_Product $product Product object.
             * @param bool       $force Force update. Used during create.
             * @since 3.0.0
             */
            public function update_post_meta( &$product, $force = false ) {
                
                
                $meta_key_to_props = array(
                    '_variation_description' => 'description',
                );

                $props_to_update = $force ? $meta_key_to_props : $this->get_props_to_update( $product, $meta_key_to_props );

                foreach ( $props_to_update as $meta_key => $prop ) {
                    $value   = $product->{"get_$prop"}( 'edit' );
                    $updated = update_post_meta( $product->get_id(), $meta_key, $value );
                    if ( $updated ) {
                        $this->updated_props[] = $prop;
                    }
                }
                
                global $wpdb, $blog_id;
                
                $meta_key_to_props = array(
                    '_sku'                   => 'sku',
                    '_regular_price'         => 'regular_price',
                    '_sale_price'            => 'sale_price',
                    '_sale_price_dates_from' => 'date_on_sale_from',
                    '_sale_price_dates_to'   => 'date_on_sale_to',
                    'total_sales'            => 'total_sales',
                    '_tax_status'            => 'tax_status',
                    '_tax_class'             => 'tax_class',
                    '_manage_stock'          => 'manage_stock',
                    '_backorders'            => 'backorders',
                    '_low_stock_amount'      => 'low_stock_amount',
                    '_sold_individually'     => 'sold_individually',
                    '_weight'                => 'weight',
                    '_length'                => 'length',
                    '_width'                 => 'width',
                    '_height'                => 'height',
                    '_upsell_ids'            => 'upsell_ids',
                    '_crosssell_ids'         => 'cross_sell_ids',
                    '_purchase_note'         => 'purchase_note',
                    '_default_attributes'    => 'default_attributes',
                    '_virtual'               => 'virtual',
                    '_downloadable'          => 'downloadable',
                    '_product_image_gallery' => 'gallery_image_ids',
                    '_download_limit'        => 'download_limit',
                    '_download_expiry'       => 'download_expiry',
                    '_thumbnail_id'          => 'image_id',
                    '_stock'                 => 'stock_quantity',
                    '_stock_status'          => 'stock_status',
                    '_wc_average_rating'     => 'average_rating',
                    '_wc_rating_count'       => 'rating_counts',
                    '_wc_review_count'       => 'review_count',
                );

                // Make sure to take extra data (like product url or text for external products) into account.
                $extra_data_keys = $product->get_extra_data_keys();

                foreach ( $extra_data_keys as $key ) {
                    $meta_key_to_props[ '_' . $key ] = $key;
                }

                $props_to_update = $force ? $meta_key_to_props : $this->get_props_to_update( $product, $meta_key_to_props );

                foreach ( $props_to_update as $meta_key => $prop ) {
                    $value = $product->{"get_$prop"}( 'edit' );
                    $value = is_string( $value ) ? wp_slash( $value ) : $value;
                    switch ( $prop ) {
                        case 'virtual':
                        case 'downloadable':
                        case 'manage_stock':
                        case 'sold_individually':
                            $updated = update_post_meta( $product->get_id(), $meta_key, wc_bool_to_string( $value ) );
                            break;
                        case 'gallery_image_ids':
                            $updated = update_post_meta( $product->get_id(), $meta_key, implode( ',', $value ) );
                            break;
                        case 'image_id':
                            if ( ! empty( $value ) ) {
                                set_post_thumbnail( $product->get_id(), $value );
                            } else {
                                delete_post_meta( $product->get_id(), '_thumbnail_id' );
                            }
                            $updated = true;
                            break;
                        case 'date_on_sale_from':
                        case 'date_on_sale_to':
                            $updated = update_post_meta( $product->get_id(), $meta_key, $value ? $value->getTimestamp() : '' );
                            break;
                        case 'regular_price':
                        case 'sale_price':
                            
                            if ( $blog_id > 1 )
                                $meta_key    =   '_' .   $wpdb->base_prefix  .   $blog_id    .  $meta_key;   
                            
                            $updated = update_post_meta( $product->get_id(), $meta_key, $value );
                                                    
                            break;
                        default:
                            $updated = update_post_meta( $product->get_id(), $meta_key, $value );
                            break;
                    }
                    if ( $updated ) {
                        $this->updated_props[] = $prop;
                    }
                }
                

                // Update extra data associated with the product like button text or product URL for external products.
                if ( ! $this->extra_data_saved ) {
                    foreach ( $extra_data_keys as $key ) {
                        if ( ! array_key_exists( '_' . $key, $props_to_update ) ) {
                            continue;
                        }
                        $function = 'get_' . $key;
                        if ( is_callable( array( $product, $function ) ) ) {
                            $value = $product->{$function}( 'edit' );
                            $value = is_string( $value ) ? wp_slash( $value ) : $value;

                            if ( update_post_meta( $product->get_id(), '_' . $key, $value ) ) {
                                $this->updated_props[] = $key;
                            }
                        }
                    }
                }

                if ( $this->update_downloads( $product, $force ) ) {
                    $this->updated_props[] = 'downloads';
                }
            }
            
            
            
            protected function check_if_fields_exists( $object_id )
                {
                    
                    global $wpdb, $blog_id;
                    
                    //no need to run for main shop
                    if  ( $blog_id < 2 )
                        return;
                         
                    $_meta_keys  =   array(
                                                    '_regular_price',
                                                    '_sale_price',
                                                    '_price'
                                                    );    
                    
                    foreach ( $_meta_keys   as  $_meta_key )
                        {
                            
                            $_object_meta_key         =   '_' .   $wpdb->base_prefix  .   $blog_id .  $_meta_key;
                                
                            $mysql_query    =   $wpdb->prepare( "SELECT meta_id FROM " . $wpdb->postmeta ."
                                                                WHERE post_id   =   %d  AND meta_key    =   %s", $object_id, $_object_meta_key );
                            $meta_value        =           $wpdb->get_var( $mysql_query);

                            if (  $meta_value   === null )
                                {                            
                                    //check if the meta entry exists
                                    $mysql_query    =   $wpdb->prepare("SELECT meta_value FROM " . $wpdb->postmeta ."
                                                                WHERE post_id   =   %d  AND meta_key    =   %s", $object_id, $_meta_key );
                                    $meta_value     =   $wpdb->get_var( $mysql_query);
                                    
                                    $mysql_query    =   $wpdb->prepare("INSERT INTO " . $wpdb->postmeta ." 
                                                                (`meta_id`, `post_id`, `meta_key`, `meta_value`) VALUES (NULL, %d, %s, %s);", $object_id, $_object_meta_key, $meta_value);
                                    $result         =   $wpdb->get_results( $mysql_query);
                                }   
                            
                            
                        }
                    
                }
	        
        }
        
        
?>