<?php
/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the html field for general tab.
 *
 * @link       https://wpswings.com/
 * @since      3.0.0
 *
 * @package    Wordpress_Pdf_Generator
 * @subpackage Wordpress_Pdf_Generator/admin/partials
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
global $pgfw_mwb_pgfw_obj, $wpg_mwb_wpg_obj;
$pgfw_active_tab           = isset( $_GET['pgfw_tab'] ) ? sanitize_key( $_GET['pgfw_tab'] ) : 'wordpress-pdf-generator-layout-settings'; // phpcs:ignore WordPress.Security.NonceVerification
$pgfw_default_tabs         = $pgfw_mwb_pgfw_obj->mwb_pgfw_plug_layout_setting_sub_tabs();
$wpg_template_settings_arr = apply_filters( 'wpg_tamplates_settings_array', array() );
?>
<main class="mwb-main mwb-bg-white mwb-r-8">
	<nav class="mwb-navbar">
		<ul class="mwb-navbar__items">
			<?php
			if ( is_array( $pgfw_default_tabs ) && ! empty( $pgfw_default_tabs ) ) {

				foreach ( $pgfw_default_tabs as $pgfw_tab_key => $pgfw_default_tabs ) {

					$pgfw_tab_classes = 'mwb-link ';

					if ( ! empty( $pgfw_active_tab ) && $pgfw_active_tab === $pgfw_tab_key ) {
						$pgfw_tab_classes .= 'active';
					}
					?>
					<li>
						<a id="<?php echo esc_attr( $pgfw_tab_key ); ?>" href="<?php echo esc_url( admin_url( 'admin.php?page=pdf_generator_for_wp_menu' ) . '&pgfw_tab=' . esc_attr( $pgfw_tab_key ) ); ?>" class="<?php echo esc_attr( $pgfw_tab_classes ); ?>"><?php echo esc_html( $pgfw_default_tabs['title'] ); ?></a>
					</li>
					<?php
				}
			}
			?>
		</ul>
	</nav>

<!--  template file for admin settings. -->
<section class="mwb-section">
	<div>
		<form action="" method="POST" class="mwb-pgfw-gen-section-form">
			<div class="wpg-admin-notice-custom"></div>
			<div class="pgfw-secion-wrap">
				<?php
				$custom_template_data             = get_option( 'wpg_custom_templates_list', array() );
				$wpg_use_template_to_generate_pdf = get_option( 'wpg_use_template_to_generate_pdf' );
				$preview_output_href              = add_query_arg(
					array(
						'action'   => 'previewpdf',
						'template' => 'template1',
					),
					get_site_url()
				);
				?>
				<div class="wpg-adding-notice-for-custom-template">
					<?php
					esc_html_e(
						'To add custom template just click on the Create Templates icon, this will add three page each for header, body and footer with default layouts you can edit them by clicking on the edit link, it will redirect you to the editor, you can add snippets from PDF Snippets block, which is provided in the block section of the gutenberg editor and choose accordingly.',
						'wordpress-pdf-generator'
					);
					?>
				</div>
				<div class="wpg-adding-notice-for-custom-template">
					<?php
					esc_html_e(
						'To add post thumbnail on the PDF, just click on the body editing link, it will redirect you to editor, there you can add any image of desired size, that image will be replaced by the post thumbnail of the size you have just selected image.',
						'wordpress-pdf-generator'
					);
					?>
				</div>
				<div class="wpg-adding-notice-for-custom-template">
					<?php
					esc_html_e(
						'To set the content on the page, If you see any Issue with top placement of header, just visit PDF Settings/Header tab, from that setting page change the value of Header top placement, If you see any issue with the footer placement just visit PDF Settings/Footer tab change the value of Footer bottom placement, Also these changes needs to be done in synchronisation with the setting at the PDF setting/ Body page for Page Margin, These will set the content on the PDF.',
						'wordpress-pdf-generator'
					);
					?>
				</div>
				<span class="wpg-add-custom-page-insertion"><?php esc_html_e( 'Create Templates', 'wordpress-pdf-generator' ); ?></span>
				<table class="mwb-layout-table-bottom">
					<thead>
						<tr>
							<th><?php esc_html_e( 'Name', 'wordpress-pdf-generator' ); ?></th>
							<th><?php esc_html_e( 'For', 'wordpress-pdf-generator' ); ?></th>
							<th><?php esc_html_e( 'Status', 'wordpress-pdf-generator' ); ?></th>
							<th><?php esc_html_e( 'Updated', 'wordpress-pdf-generator' ); ?></th>
							<th><?php esc_html_e( 'Preview', 'wordpress-pdf-generator' ); ?></th>
							<th><?php esc_html_e( 'Template Editing Link', 'wordpress-pdf-generator' ); ?></th>
							<th><?php esc_html_e( 'Delete', 'wordpress-pdf-generator' ); ?></th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td><?php esc_html_e( 'Template 1', 'wordpress-pdf-generator' ); ?></td>
							<td><?php esc_html_e( 'All Posts', 'wordpress-pdf-generator' ); ?></td>
							<td>
								<input type="radio" name="wpg_use_template_current_status" class="wpg_use_template_current_status" value="template1" <?php checked( $wpg_use_template_to_generate_pdf, 'template1' ); ?>>
								<span><?php esc_html_e( 'Activate', 'wordpress-pdf-generator' ); ?></span>
							</td>
							<td>
								<?php echo esc_html( get_option( 'date_format' ) ); ?>
							</td>
							<td>
								<a href="<?php echo esc_attr( $preview_output_href ); ?>" target="_blank"><?php esc_html_e( 'Preview', 'wordpress-pdf-generator' ); ?></a>
							</td>
							<td>
								<span><?php esc_html_e( 'Not Found', 'wordpress-pdf-generator' ); ?><span>
							</td>
							<td>
								<span><?php esc_html_e( 'not allowed', 'wordpress-pdf-generator' ); ?></span>
							</td>
						</tr>
						<?php
						$translated_pdf_parts = array(
							'header' => __( 'Header', 'wordpress-pdf-generator' ),
							'body'   => __( 'Body', 'wordpress-pdf-generator' ),
							'footer' => __( 'Footer', 'wordpress-pdf-generator' ),
						);
						foreach ( $custom_template_data as $template => $template_description ) {
							$preview_output_href = add_query_arg(
								array(
									'action'   => 'previewpdf',
									'template' => $template,
								),
								get_site_url()
							);
							$i                   = 0;
							foreach ( $template_description as $template_for => $template_id ) {
								$availability = get_post( $template_id );
								$edit_link    = get_edit_post_link( $availability );
								?>
								<tr>
									<?php if ( 0 === $i ) { ?>
										<td rowspan="3"><?php echo esc_html( str_replace( 'customtemplate', __( 'Custom Template ', 'wordpress-pdf-generator' ), $template ) ); ?></td>
										<td rowspan="3">
											<span><?php esc_html_e( 'All Posts', 'wordpress-pdf-generator' ); ?></span>
										</td>
										<td rowspan="3">
											<input type="radio" name="wpg_use_template_current_status" class="wpg_use_template_current_status" value="<?php echo esc_html( $template ); ?>" <?php checked( $wpg_use_template_to_generate_pdf, $template ); ?>>
											<span><?php esc_html_e( 'Activate', 'wordpress-pdf-generator' ); ?></span>
										</td>
										<td rowspan="3"><?php echo esc_html( ( $availability ) ? get_the_modified_date( '', $template_id ) : __( 'Not Found', 'wordpress-pdf-generator' ) ); ?></td>
									<?php } ?>
									<?php if ( 0 === $i ) { ?>
										<td rowspan="3">
											<a href="<?php echo esc_attr( $preview_output_href ); ?>" target="_blank"><?php esc_html_e( 'Preview', 'wordpress-pdf-generator' ); ?></a>
										</td>
									<?php } ?>
									<?php if ( $edit_link ) { ?>
										<td class="<?php echo ( 2 !== $i ) ? esc_attr( 'wpg-no-border-table' ) : 'wpg-no-border-top-table'; ?>"><a href="<?php echo esc_attr( $edit_link ); ?>" target="_blank"><?php echo esc_html( isset( $translated_pdf_parts[ $template_for ] ) ? $translated_pdf_parts[ $template_for ] : $template_for ); ?></a></td>
									<?php } else { ?>
										<td>
											<span><?php esc_html_e( 'Not Found', 'wordpress-pdf-generator' ); ?><span>
										</td>
										<?php
									}
									if ( 0 === $i ) {
										?>
										<td rowspan="3">
											<button data-template-name="<?php echo esc_html( $template ); ?>" class="wpg-delete-template"><?php esc_html_e( 'Delete', 'wordpress-pdf-generator' ); ?></button>
										</td>
									<?php } ?>
								</tr>
								<?php
								$i++;
							}
						}
						?>
					</tbody>
				</table>
				<div class="mpg-submit-btn-wrap">
					<button class="wpg-submit-internal-page-setting"><?php esc_html_e( 'Save Setting', 'wordpress-pdf-generator' ); ?></button>
				</div>
			</div>
		</form>
	</div>
</section>
